"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymRuleFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _synonyms_utils = require("../../utils/synonyms_utils");
var _use_put_synonyms_rule = require("../../hooks/use_put_synonyms_rule");
var _use_flyout_state = require("./use_flyout_state");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/synonyms_rule_flyout/synonym_rule_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SynonymRuleFlyout = ({
  flyoutMode,
  synonymsRule,
  onClose,
  renderExplicit = false,
  synonymsSetId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [backendError, setBackendError] = _react.default.useState(null);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    mutate: putSynonymsRule
  } = (0, _use_put_synonyms_rule.usePutSynonymsRule)(() => onClose(), error => {
    setBackendError(error);
  });
  const {
    canSave,
    currentSortDirection,
    fromTermErrors,
    fromTerms,
    hasChanges,
    isExplicit,
    isFromTermsInvalid,
    isMapToTermsInvalid,
    mapToTermErrors,
    mapToTerms,
    announcement,
    clearFromTerms,
    onCreateOption,
    onMapToChange,
    onSearchChange,
    onSortTerms,
    removeTermFromOptions,
    resetChanges
  } = (0, _use_flyout_state.useSynonymRuleFlyoutState)({
    synonymRule: synonymsRule,
    flyoutMode,
    renderExplicit
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: '33%',
    outsideClickCloses: false,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "searchSynonymsSynonymRuleFlyoutRuleIdText",
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.title.ruleId', {
    defaultMessage: 'Rule ID: {ruleId}',
    values: {
      ruleId: synonymsRule.id
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
          .euiFlyoutBody__overflowContent {
            height: 100%;
          }
        `,
    banner: backendError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      "data-test-subj": "searchSynonymsSynonymsRuleFlyoutErrorBanner",
      color: "danger",
      title: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.errorCallout.title', {
        defaultMessage: 'An error occured while saving your changes'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, backendError),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    gutterSize: "none",
    css: (0, _react2.css)`
            height: 100%;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.synonyms', {
      defaultMessage: 'Add terms to match against'
    }),
    isInvalid: isFromTermsInvalid,
    error: fromTermErrors || null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutFromTermsInput",
    isInvalid: isFromTermsInvalid,
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.synonyms.inputPlaceholder', {
      defaultMessage: 'Add terms to match against'
    }),
    onCreateOption: onCreateOption,
    delimiter: ",",
    onSearchChange: onSearchChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutTermCountLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 27
    }
  }, fromTerms.length <= 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.synonymsCount.single",
    defaultMessage: "{count} term",
    values: {
      count: fromTerms.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 31
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.synonymsCount.multiple",
    defaultMessage: "{count} terms",
    values: {
      count: fromTerms.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 31
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutSortAZButton",
    size: "s",
    color: "text",
    onClick: () => onSortTerms(),
    iconType: currentSortDirection === 'ascending' ? 'sortUp' : 'sortDown',
    "aria-label": currentSortDirection === 'ascending' ? _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.sortAscendingAriaLabel', {
      defaultMessage: 'Sort terms A to Z'
    }) : _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.sortDescendingAriaLabel', {
      defaultMessage: 'Sort terms Z to A'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 25
    }
  }, currentSortDirection === 'ascending' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.sortAZ",
    defaultMessage: "Sort A-Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 29
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.sortZA",
    defaultMessage: "Sort Z-A",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 29
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutRemoveAllButton",
    color: "danger",
    size: "s",
    onClick: clearFromTerms,
    "aria-label": _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.clearAllAriaLabel', {
      defaultMessage: 'Remove all terms'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.clearAll",
    defaultMessage: "Remove all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 23
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              max-height: ${isExplicit ? '75%' : '90%'};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    tabIndex: 0,
    className: "eui-yScrollWithShadows",
    css: (0, _react2.css)`
                margin: ${euiTheme.size.xs};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 15
    }
  }), fromTerms.map((opt, index) => /*#__PURE__*/_react.default.createElement("span", {
    key: index + '-' + opt.label.trim(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutFromTermBadge",
    color: "hollow",
    iconSide: "left",
    iconType: "cross",
    iconOnClick: () => {
      removeTermFromOptions(opt);
    },
    iconOnClickAriaLabel: "remove",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 19
    }
  }, "\xA0", opt.label))), fromTerms.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center",
    size: "s",
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutNoTermsText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.noTerms",
    defaultMessage: "No terms found.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 15
    }
  }))), isExplicit && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.synonymsTo', {
      defaultMessage: 'Map to this term'
    }),
    isInvalid: mapToTerms !== '' && isMapToTermsInvalid,
    error: mapToTermErrors || null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    prepend: '=>',
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutMapToTermsInput",
    fullWidth: true,
    value: mapToTerms,
    isInvalid: mapToTerms !== '' && isMapToTermsInvalid,
    onChange: e => {
      onMapToChange(e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }, hasChanges && /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "primary",
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutHasChangesBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.unsavedChanges', {
    defaultMessage: 'Synonym rule has unsaved changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutResetChangesButton",
    "aria-label": _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.resetAriaLabel', {
      defaultMessage: 'Reset all changes'
    }),
    iconType: "refresh",
    disabled: !hasChanges,
    onClick: resetChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.reset', {
    defaultMessage: 'Reset changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "aria-live": "polite",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 17
    }
  }, announcement)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutSaveButton",
    fill: true,
    disabled: !canSave,
    onClick: () => {
      if (!synonymsRule.id) {
        return;
      }
      if (flyoutMode === 'create') {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.new_rule_created);
      } else {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.rule_updated);
      }
      putSynonymsRule({
        synonymsSetId,
        ruleId: synonymsRule.id,
        synonyms: (0, _synonyms_utils.synonymsOptionToString)({
          fromTerms,
          toTerms: mapToTerms,
          isExplicit
        })
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.save', {
    defaultMessage: 'Save'
  }))))))));
};
exports.SynonymRuleFlyout = SynonymRuleFlyout;