"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APIRoutes", {
  enumerable: true,
  get: function () {
    return _types.APIRoutes;
  }
});
exports.SEARCH_MODE_FEATURE_FLAG_ID = exports.ROUTE_VERSIONS = exports.PLUGIN_PATH = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.PLAYGROUND_SAVED_OBJECT_TYPE = exports.DEFAULT_PAGINATION = exports.DEFAULT_CONTEXT_DOCUMENTS = exports.ContextModelLimitError = void 0;
Object.defineProperty(exports, "SearchPlaygroundMutationKeys", {
  enumerable: true,
  get: function () {
    return _query_keys.SearchPlaygroundMutationKeys;
  }
});
Object.defineProperty(exports, "SearchPlaygroundQueryKeys", {
  enumerable: true,
  get: function () {
    return _query_keys.SearchPlaygroundQueryKeys;
  }
});
var _i18n = require("@kbn/i18n");
var _types = require("./types");
var _query_keys = require("./query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'searchPlayground';
const PLUGIN_NAME = exports.PLUGIN_NAME = _i18n.i18n.translate('xpack.searchPlayground.plugin.name', {
  defaultMessage: 'Playground'
});
const PLUGIN_PATH = exports.PLUGIN_PATH = '/app/search_playground';
const SEARCH_MODE_FEATURE_FLAG_ID = exports.SEARCH_MODE_FEATURE_FLAG_ID = 'searchPlayground:searchModeEnabled';
const DEFAULT_PAGINATION = exports.DEFAULT_PAGINATION = {
  from: 0,
  size: 10,
  total: 0
};
const ContextModelLimitError = exports.ContextModelLimitError = _i18n.i18n.translate('xpack.searchPlayground.error.contextLimitError', {
  defaultMessage: 'Context exceeds the model limit'
});
let ROUTE_VERSIONS = exports.ROUTE_VERSIONS = /*#__PURE__*/function (ROUTE_VERSIONS) {
  ROUTE_VERSIONS["v1"] = "1";
  return ROUTE_VERSIONS;
}({});
const PLAYGROUND_SAVED_OBJECT_TYPE = exports.PLAYGROUND_SAVED_OBJECT_TYPE = 'search_playground';
const DEFAULT_CONTEXT_DOCUMENTS = exports.DEFAULT_CONTEXT_DOCUMENTS = 3;