"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSearchResults = void 0;
var _types = require("../types");
var _escape_lucene_charts = require("../utils/escape_lucene_charts");
var _fetch_with_pagination = require("../utils/fetch_with_pagination");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSearchResults = async (client, indexName, query, from = 0, size = _types.DEFAULT_DOCS_PER_PAGE, trackTotalHits) => {
  return (0, _fetch_with_pagination.fetchWithPagination)(() => client.search({
    from,
    index: indexName,
    size,
    ...(!!query ? {
      q: (0, _escape_lucene_charts.escapeLuceneChars)(query)
    } : {}),
    track_total_hits: trackTotalHits
  }), from, size);
};
exports.fetchSearchResults = fetchSearchResults;