"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureDefaultElserDeployed = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ensureDefaultElserDeployed = async ({
  client
}) => {
  await client.inference.inference({
    inference_id: _inferenceCommon.defaultInferenceEndpoints.ELSER,
    input: 'I just want to call the API to force the model to download and allocate',
    timeout: '2m'
  }, {
    requestTimeout: 10 * 60 * 1000
  });
};
exports.ensureDefaultElserDeployed = ensureDefaultElserDeployed;