"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldEditorFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _runtime_field_editor = require("../runtime_field_editor/runtime_field_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/runtime_fields/public/components/runtime_field_editor_flyout_content/runtime_field_editor_flyout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const geti18nTexts = field => {
  return {
    flyoutTitle: field ? _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutEditFieldTitle', {
      defaultMessage: 'Edit {fieldName} field',
      values: {
        fieldName: field.name
      }
    }) : _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutDefaultTitle', {
      defaultMessage: 'Create new field'
    }),
    closeButtonLabel: _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutCloseButtonLabel', {
      defaultMessage: 'Close'
    }),
    saveButtonLabel: _i18n.i18n.translate('xpack.runtimeFields.editor.flyoutSaveButtonLabel', {
      defaultMessage: 'Save'
    }),
    formErrorsCalloutTitle: _i18n.i18n.translate('xpack.runtimeFields.editor.validationErrorTitle', {
      defaultMessage: 'Fix errors in form before continuing.'
    })
  };
};
const RuntimeFieldEditorFlyoutContent = ({
  onSave,
  onCancel,
  docLinks,
  defaultValue: field,
  ctx
}) => {
  const i18nTexts = geti18nTexts(field);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isValid: field ? true : undefined,
    submit: field ? async () => ({
      isValid: true,
      data: field
    }) : async () => ({
      isValid: false,
      data: {}
    })
  });
  const {
    submit,
    isValid: isFormValid,
    isSubmitted
  } = formState;
  const onSaveField = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await submit();
    if (isValid) {
      onSave(data);
    }
  }, [submit, onSave]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "runtimeFieldEditorEditTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, i18nTexts.flyoutTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_runtime_field_editor.RuntimeFieldEditor, {
    docLinks: docLinks,
    defaultValue: field,
    onChange: setFormState,
    ctx: ctx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, isSubmitted && !isFormValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.formErrorsCalloutTitle,
    color: "danger",
    iconType: "cross",
    "data-test-subj": "formError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: () => onCancel(),
    "data-test-subj": "closeFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, i18nTexts.closeButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => onSaveField(),
    "data-test-subj": "saveFieldButton",
    disabled: isSubmitted && !isFormValid,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, i18nTexts.saveButtonLabel)))));
};
exports.RuntimeFieldEditorFlyoutContent = RuntimeFieldEditorFlyoutContent;