"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../../../../common");
var _services = require("../../../services");
var _kibana_services = require("../../../../kibana_services");
var _components = require("../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_list/job_table/job_table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COLUMNS = [{
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.nameHeader', {
    defaultMessage: 'ID'
  }),
  fieldName: 'id',
  isSortable: true
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.statusHeader', {
    defaultMessage: 'Status'
  }),
  fieldName: 'status',
  isSortable: true,
  render: ({
    status,
    rollupCron
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      placement: "top",
      content: `Cron: ${rollupCron}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_components.JobStatus, {
      status: status,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }));
  }
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.indexPatternHeader', {
    defaultMessage: 'Index pattern'
  }),
  truncateText: true,
  fieldName: 'indexPattern',
  isSortable: true
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.rollupIndexHeader', {
    defaultMessage: 'Rollup index'
  }),
  truncateText: true,
  fieldName: 'rollupIndex',
  isSortable: true
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.delayHeader', {
    defaultMessage: 'Delay'
  }),
  fieldName: 'rollupDelay',
  isSortable: true,
  render: ({
    rollupDelay
  }) => rollupDelay || 'None'
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.intervalHeader', {
    defaultMessage: 'Interval'
  }),
  fieldName: 'dateHistogramInterval',
  isSortable: true
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.groupsHeader', {
    defaultMessage: 'Groups'
  }),
  fieldName: 'groups',
  isSortable: false,
  truncateText: true,
  render: job => ['histogram', 'terms'].reduce((text, field) => {
    if (job[field].length) {
      return text ? `${text}, ${field}` : field.replace(/^\w/, char => char.toUpperCase());
    }
    return text;
  }, '')
}, {
  name: _i18n.i18n.translate('xpack.rollupJobs.jobTable.headers.metricsHeader', {
    defaultMessage: 'Metrics'
  }),
  fieldName: 'metrics',
  isSortable: false,
  truncateText: true,
  render: job => {
    const {
      metrics
    } = job;
    if (metrics.length) {
      return metrics.map(metric => metric.name).join(', ');
    }
    return '';
  }
}];
class JobTable extends _react.Component {
  static getDerivedStateFromProps(props, state) {
    // Deselct any jobs which no longer exist, e.g. they've been deleted.
    const {
      idToSelectedJobMap
    } = state;
    const jobIds = props.jobs.map(job => job.id);
    const selectedJobIds = Object.keys(idToSelectedJobMap);
    const missingJobIds = selectedJobIds.filter(selectedJobId => {
      return !jobIds.includes(selectedJobId);
    });
    if (missingJobIds.length) {
      const newMap = {
        ...idToSelectedJobMap
      };
      missingJobIds.forEach(missingJobId => delete newMap[missingJobId]);
      return {
        idToSelectedJobMap: newMap
      };
    }
    return null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "toggleAll", () => {
      const allSelected = this.areAllItemsSelected();
      if (allSelected) {
        return this.setState({
          idToSelectedJobMap: {}
        });
      }
      const {
        jobs
      } = this.props;
      const idToSelectedJobMap = {};
      jobs.forEach(({
        id
      }) => {
        idToSelectedJobMap[id] = true;
      });
      this.setState({
        idToSelectedJobMap
      });
    });
    (0, _defineProperty2.default)(this, "toggleItem", id => {
      this.setState(({
        idToSelectedJobMap
      }) => {
        const newMap = {
          ...idToSelectedJobMap
        };
        if (newMap[id]) {
          delete newMap[id];
        } else {
          newMap[id] = true;
        }
        return {
          idToSelectedJobMap: newMap
        };
      });
    });
    (0, _defineProperty2.default)(this, "resetSelection", () => {
      this.setState({
        idToSelectedJobMap: {}
      });
    });
    (0, _defineProperty2.default)(this, "deselectItems", itemIds => {
      this.setState(({
        idToSelectedJobMap
      }) => {
        const newMap = {
          ...idToSelectedJobMap
        };
        itemIds.forEach(id => delete newMap[id]);
        return {
          idToSelectedJobMap: newMap
        };
      });
    });
    (0, _defineProperty2.default)(this, "areAllItemsSelected", () => {
      const {
        jobs
      } = this.props;
      const indexOfUnselectedItem = jobs.findIndex(job => !this.isItemSelected(job.id));
      return indexOfUnselectedItem === -1;
    });
    (0, _defineProperty2.default)(this, "isItemSelected", id => {
      return !!this.state.idToSelectedJobMap[id];
    });
    (0, _defineProperty2.default)(this, "onSort", column => {
      const {
        sortField,
        isSortAscending,
        sortChanged
      } = this.props;
      const newIsSortAscending = sortField === column ? !isSortAscending : true;
      sortChanged(column, newIsSortAscending);
    });
    this.state = {
      idToSelectedJobMap: {}
    };
  }
  getSelectedJobs() {
    const {
      jobs
    } = this.props;
    const {
      idToSelectedJobMap
    } = this.state;
    return Object.keys(idToSelectedJobMap).map(jobId => {
      return jobs.find(job => job.id === jobId);
    });
  }
  buildHeader() {
    const {
      sortField,
      isSortAscending
    } = this.props;
    return COLUMNS.map(({
      name,
      fieldName,
      isSortable
    }) => {
      const isSorted = sortField === fieldName;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
        key: name,
        onSort: isSortable ? () => this.onSort(fieldName) : undefined,
        isSorted: isSorted,
        isSortAscending: isSortAscending,
        "data-test-subj": `jobTableHeaderCell-${fieldName}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 9
        }
      }, name);
    });
  }
  buildRowCells(job) {
    const {
      openDetailPanel
    } = this.props;
    return COLUMNS.map(({
      name,
      fieldName,
      render,
      truncateText
    }) => {
      const value = render ? render(job) : job[fieldName];
      let content;
      if (fieldName === 'id') {
        content = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            (0, _kibana_services.trackUiMetric)(_services.METRIC_TYPE.CLICK, _common.UIM_SHOW_DETAILS_CLICK);
            openDetailPanel(encodeURIComponent(job.id));
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 11
          }
        }, value);
      } else {
        content = /*#__PURE__*/_react.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 277,
            columnNumber: 19
          }
        }, value);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        key: `${job.id}-${name}`,
        "data-test-subj": `jobTableCell-${fieldName}`,
        truncateText: truncateText,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 9
        }
      }, truncateText ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        anchorClassName: "eui-textTruncate",
        content: value,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 13
        }
      }, content) : content);
    });
  }
  buildRows() {
    const {
      jobs
    } = this.props;
    return jobs.map(job => {
      const {
        id
      } = job;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        key: `${id}-row`,
        "data-test-subj": "jobTableRow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 305,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, {
        key: `checkbox-${id}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: `checkboxSelectIndex-${id}`,
        checked: this.isItemSelected(id),
        onChange: () => {
          this.toggleItem(id);
        },
        "data-test-subj": `indexTableRowCheckbox-${id}`,
        "aria-label": _i18n.i18n.translate('xpack.rollupJobs.jobTable.selectRow', {
          defaultMessage: 'Select this row {id}',
          values: {
            id
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 13
        }
      })), this.buildRowCells(job));
    });
  }
  renderPager() {
    const {
      pager,
      pageChanged,
      pageSizeChanged
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
      activePage: pager.getCurrentPageIndex(),
      itemsPerPage: pager.itemsPerPage,
      itemsPerPageOptions: [20, 50, 100],
      pageCount: pager.getTotalPages(),
      onChangeItemsPerPage: pageSizeChanged,
      onChangePage: pageChanged,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 7
      }
    });
  }
  render() {
    const {
      filterChanged,
      filter,
      jobs,
      closeDetailPanel
    } = this.props;
    const {
      idToSelectedJobMap
    } = this.state;
    const atLeastOneItemSelected = Object.keys(idToSelectedJobMap).length > 0;
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 9
      }
    }, atLeastOneItemSelected && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_components.JobActionMenu, {
      jobs: this.getSelectedJobs(),
      closeDetailPanel: closeDetailPanel,
      resetSelection: this.resetSelection,
      deselectJobs: this.deselectItems,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      fullWidth: true,
      value: filter,
      onChange: event => {
        filterChanged(event.target.value);
      },
      "data-test-subj": "jobTableFilterInput",
      placeholder: _i18n.i18n.translate('xpack.rollupJobs.jobTable.searchInputPlaceholder', {
        defaultMessage: 'Search'
      }),
      "aria-label": "Search jobs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      fill: true
    }, (0, _services.getRouterLinkProps)('/create'), {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobList.createButtonLabel",
      defaultMessage: "Create rollup job",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 9
      }
    }), jobs.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
      "data-test-subj": "rollupJobsListTable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCellCheckbox, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "selectAllJobsCheckbox",
      checked: this.areAllItemsSelected(),
      onChange: this.toggleAll,
      "aria-label": _i18n.i18n.translate('xpack.rollupJobs.jobTable.selectAllRows', {
        defaultMessage: 'Select all rows'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 17
      }
    })), this.buildHeader()), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 13
      }
    }, this.buildRows())) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 406,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 407,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobTable.noJobsMatchSearchMessage",
      defaultMessage: "No rollup jobs match your search",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 9
      }
    }), jobs.length > 0 ? this.renderPager() : null);
  }
}
exports.JobTable = JobTable;
(0, _defineProperty2.default)(JobTable, "propTypes", {
  jobs: _propTypes.default.array,
  pager: _propTypes.default.object.isRequired,
  filter: _propTypes.default.string.isRequired,
  sortField: _propTypes.default.string.isRequired,
  isSortAscending: _propTypes.default.bool.isRequired,
  openDetailPanel: _propTypes.default.func.isRequired,
  closeDetailPanel: _propTypes.default.func.isRequired,
  filterChanged: _propTypes.default.func.isRequired,
  pageChanged: _propTypes.default.func.isRequired,
  pageSizeChanged: _propTypes.default.func.isRequired,
  sortChanged: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(JobTable, "defaultProps", {
  jobs: []
});