"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_status = require("../../job_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/components/job_details/tabs/tab_summary.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TabSummary extends _react.Component {
  renderStats() {
    const {
      stats
    } = this.props;
    if (!stats) {
      return null;
    }
    const {
      documentsProcessed,
      pagesProcessed,
      rollupsIndexed,
      triggerCount,
      status
    } = stats;
    return /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "rollupJobDetailStatsTitle",
      "data-test-subj": "rollupJobDetailSummaryStatsSection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "rollupJobDetailStatsTitle",
      "data-test-subj": "rollupJobDetailStatsTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.sectionStatsTitle",
      defaultMessage: "Stats",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_job_status.JobStatus, {
      status: status,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemDocumentsProcessedLabel",
      "data-test-subj": "rollupJobDetailStatsDocumentsProcessedTitle",
      defaultMessage: "Documents processed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsDocumentsProcessedDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 15
      }
    }, documentsProcessed), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemRollupsIndexedLabel",
      "data-test-subj": "rollupJobDetailStatsRollupsIndexedTitle",
      defaultMessage: "Rollups indexed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsRollupsIndexedDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }, rollupsIndexed))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemPagesProcessedLabel",
      "data-test-subj": "rollupJobDetailStatsPagesProcessedTitle",
      defaultMessage: "Pages processed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsPagesProcessedDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }, pagesProcessed), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemTriggerCountLabel",
      "data-test-subj": "rollupJobDetailStatsTriggerCountTitle",
      defaultMessage: "Trigger count",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailStatsTriggerCountDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    }, triggerCount)))));
  }
  render() {
    const {
      job
    } = this.props;
    const {
      indexPattern,
      rollupIndex,
      rollupCron,
      rollupDelay,
      dateHistogramInterval,
      dateHistogramTimeZone,
      dateHistogramField
    } = job;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "rollupJobDetailLogisticsTitle",
      "data-test-subj": "rollupJobDetailSummaryLogisticsSection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "rollupJobDetailLogisticsTitle",
      "data-test-subj": "rollupJobDetailLogisticsTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.sectionLogisticsLabel",
      defaultMessage: "Logistics",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemIndexPatternLabel",
      "data-test-subj": "rollupJobDetailLogisticsIndexPatternTitle",
      defaultMessage: "Index pattern",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "rollupJobDetailLogisticsIndexPatternDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, indexPattern), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemCronLabel",
      "data-test-subj": "rollupJobDetailLogisticsCronTitle",
      defaultMessage: "Cron",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 19
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobDetails.tabSummary.itemCronTip",
        defaultMessage: "The frequency with which data is rolled up",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 23
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailLogisticsCronDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }, rollupCron))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemRollupIndexLabel",
      "data-test-subj": "rollupJobDetailLogisticsRollupIndexTitle",
      defaultMessage: "Rollup index",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "rollupJobDetailLogisticsRollupIndexDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 17
      }
    }, rollupIndex), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemDelayLabel",
      "data-test-subj": "rollupJobDetailLogisticsDelayTitle",
      defaultMessage: "Delay",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailLogisticsDelayDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 17
      }
    }, rollupDelay || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemDelay.none",
      defaultMessage: "None",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 21
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "rollupJobDetailDateHistogramTitle",
      "data-test-subj": "rollupJobDetailSummaryDateHistogramSection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "rollupJobDetailDateHistogramTitle",
      "data-test-subj": "rollupJobDetailDateHistogramTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.sectionDateHistogramLabel",
      defaultMessage: "Date histogram",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemTimeFieldLabel",
      "data-test-subj": "rollupJobDetailDateHistogramTimeFieldTitle",
      defaultMessage: "Time field",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "rollupJobDetailDateHistogramTimeFieldDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 17
      }
    }, dateHistogramField), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemIntervalLabel",
      "data-test-subj": "rollupJobDetailDateHistogramIntervalTitle",
      defaultMessage: "Interval",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 19
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobDetails.tabSummary.itemIntervalTip",
        defaultMessage: "The time bucket interval into which data is rolled up",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 23
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailDateHistogramIntervalDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 17
      }
    }, dateHistogramInterval))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobDetails.tabSummary.itemTimezoneLabel",
      "data-test-subj": "rollupJobDetailDateHistogramTimezoneTitle",
      defaultMessage: "Timezone",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "rollupJobDetailDateHistogramTimezoneDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 17
      }
    }, dateHistogramTimeZone))))), this.renderStats());
  }
}
exports.TabSummary = TabSummary;
(0, _defineProperty2.default)(TabSummary, "propTypes", {
  job: _propTypes.default.object.isRequired,
  stats: _propTypes.default.object
});