"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTable = HostsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/host_breakdown/hosts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sorting = {
  sort: {
    field: 'hostName',
    direction: 'desc'
  }
};
function HostsTable({
  data = [],
  hasDistinctProbabilisticValues
}) {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo
  } = query;
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  function onTableChange({
    page: {
      index
    }
  }) {
    setPagination({
      pageIndex: index
    });
  }
  const probabilisticValuesCountPerProjectId = data.reduce((acc, curr) => {
    var _acc$projectId;
    const projectId = curr.projectId;
    const currentCount = (_acc$projectId = acc[projectId]) !== null && _acc$projectId !== void 0 ? _acc$projectId : 0;
    return {
      ...acc,
      [projectId]: currentCount + 1
    };
  }, {});
  const columns = (0, _react.useMemo)(() => [...(hasDistinctProbabilisticValues ? [{
    field: 'distinctProbabilisticWarning',
    width: '30',
    name: '',
    sortable: true,
    render: (_, item) => {
      if (probabilisticValuesCountPerProjectId[item.projectId] > 1) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.distinctProbabilisticValues', {
            defaultMessage: "We've identified distinct probabilistic profiling values for the same project"
          }),
          type: "warning",
          color: "warning",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 21
          }
        });
      }
    }
  }] : []), {
    field: 'projectId',
    width: '100',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.projectId', {
      defaultMessage: 'Project ID'
    }),
    sortable: true
  }, {
    field: 'hostName',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.host', {
      defaultMessage: 'Host'
    }),
    nameTooltip: {
      content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.host.hint', {
        defaultMessage: 'host.name[host.id]'
      })
    },
    sortable: item => `${item.hostName} [${item.hostId}]`,
    render: (_, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": `hostId_${item.hostId}`,
        className: "eui-textTruncate",
        href: profilingRouter.link('/flamegraphs/flamegraph', {
          query: {
            rangeFrom,
            rangeTo,
            kuery: `${'host.id'}: "${item.hostId}"`
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      }, `${item.hostName} [${item.hostId}]`);
    }
  }, {
    field: 'probabilisticValues',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.probabilisticValues', {
      defaultMessage: 'Probabilistic Profiling values'
    }),
    sortable: true,
    render: probabilisticValues => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }, probabilisticValues.map((value, index) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          key: index,
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 19
          }
        }, value.date ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.probabilisticProfilingValues', {
            defaultMessage: 'Introduced on {date}',
            values: {
              date: (0, _common.asAbsoluteDateTime)(value.date)
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 126,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          isDisabled: index > 0,
          tabIndex: 0,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 25
          }
        }, value.value)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          isDisabled: index > 0,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 23
          }
        }, value.value));
      }));
    }
  }, {
    field: 'totalMetricsSize',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.metricsData', {
      defaultMessage: 'Metrics data'
    }),
    sortable: true,
    width: '200',
    render: size => (0, _common.asDynamicBytes)(size)
  }, {
    field: 'totalEventsSize',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.samplesData', {
      defaultMessage: 'Samples data'
    }),
    sortable: true,
    width: '200',
    render: size => (0, _common.asDynamicBytes)(size)
  }, {
    field: 'totalSize',
    name: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.totalData', {
      defaultMessage: 'Total data'
    }),
    nameTooltip: {
      content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostsTable.totalData.hint', {
        defaultMessage: 'The combined value of Universal Profiling metrics and samples.'
      })
    },
    sortable: true,
    width: '200',
    render: size => (0, _common.asDynamicBytes)(size)
  }], [hasDistinctProbabilisticValues, probabilisticValuesCountPerProjectId, profilingRouter, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: data,
    columns: columns,
    sorting: sorting,
    pagination: {
      pageSize: 10,
      showPerPageOptions: false,
      ...pagination
    },
    onTableChange: onTableChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  });
}