"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryPackSelectable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/live_queries/form/query_pack_selectable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiCard = (0, _styled.default)(_eui.EuiCard)`
  padding: 0;
  display: flex;
  flex-direction: row;
  border: ${({
  theme,
  selectable
}) => {
  if (selectable !== null && selectable !== void 0 && selectable.isSelected) {
    return `${theme.euiTheme.border.width.thin} solid ${theme.euiTheme.colors.success}`;
  }
}};
  .euiCard__content {
    padding: 16px 92px 16px 16px !important;
  }
  .euiTitle {
    font-size: 1rem;
  }
  .euiText {
    margin-top: 0;
    color: ${({
  theme
}) => theme.euiTheme.colors.subduedText};
  }

  > button[role='switch'] {
    min-inline-size: 80px;
    height: 100% !important;
    width: 80px;
    border-radius: 0 5px 5px 0;

    > span {
      > svg {
        width: 18px;
        height: 18px;
        display: inline-block !important;
      }

      // hide the label
      > :not(svg) {
        display: none;
      }
    }
  }
`;
const QueryPackSelectable = ({
  canRunSingleQuery,
  canRunPacks
}) => {
  const {
    field: {
      value: queryType,
      onChange: setQueryType
    }
  } = (0, _reactHookForm.useController)({
    name: 'queryType',
    defaultValue: 'query',
    rules: {
      deps: ['packId', 'query']
    }
  });
  const handleChange = (0, _react.useCallback)(type => {
    setQueryType(type);
  }, [setQueryType]);
  const queryCardSelectable = (0, _react.useMemo)(() => ({
    onClick: () => handleChange('query'),
    isSelected: queryType === 'query',
    iconType: 'check',
    textProps: {} // this is needed for the text to get wrapped in span
  }), [queryType, handleChange]);
  const packCardSelectable = (0, _react.useMemo)(() => ({
    onClick: () => handleChange('pack'),
    isSelected: queryType === 'pack',
    iconType: 'check',
    textProps: {} // this is needed for the text to get wrapped in span
  }), [queryType, handleChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Query type",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiCard, {
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.singleQueryTypeLabel', {
      defaultMessage: 'Single query'
    }),
    titleSize: "xs",
    hasBorder: true,
    description: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.singleQueryTypeDescription', {
      defaultMessage: 'Run a saved query or new one.'
    }),
    selectable: queryCardSelectable,
    isDisabled: !canRunSingleQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiCard, {
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.packQueryTypeLabel', {
      defaultMessage: 'Pack'
    }),
    titleSize: "xs",
    hasBorder: true,
    description: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.packQueryTypeDescription', {
      defaultMessage: 'Run a set of queries in a pack.'
    }),
    selectable: packCardSelectable,
    isDisabled: !canRunPacks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  })))));
};
exports.QueryPackSelectable = QueryPackSelectable;