"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStorage = exports.agentsIndexName = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _onechatServer = require("@kbn/onechat-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentsIndexName = exports.agentsIndexName = (0, _onechatServer.chatSystemIndex)('agents');
const storageSettings = {
  name: agentsIndexName,
  schema: {
    properties: {
      id: _storageAdapter.types.keyword({}),
      name: _storageAdapter.types.keyword({}),
      type: _storageAdapter.types.keyword({}),
      space: _storageAdapter.types.keyword({}),
      description: _storageAdapter.types.text({}),
      labels: _storageAdapter.types.keyword({}),
      avatar_color: _storageAdapter.types.keyword({}),
      avatar_symbol: _storageAdapter.types.keyword({}),
      config: _storageAdapter.types.object({
        properties: {},
        dynamic: false
      }),
      created_at: _storageAdapter.types.date({}),
      updated_at: _storageAdapter.types.date({})
    }
  }
};

// @ts-expect-error type mismatch for labels type

const createStorage = ({
  logger,
  esClient
}) => {
  // @ts-expect-error type mismatch for labels type
  return new _storageAdapter.StorageIndexAdapter(esClient, logger, storageSettings);
};
exports.createStorage = createStorage;