"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundThinking = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _send_message_context = require("../../../../context/send_message/send_message_context");
var _round_flyout = require("../round_flyout");
var _round_steps = require("./steps/round_steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/round_thinking.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buttonContentClassName = 'thinkingButtonContent';
const defaultThinkingLabel = _i18n.i18n.translate('xpack.onechat.conversation.thinking.label', {
  defaultMessage: 'Thinking...'
});
const thinkingCompletedLabel = _i18n.i18n.translate('xpack.onechat.conversation.thinking.completed', {
  defaultMessage: 'Thinking completed'
});
const rawResponseButtonLabel = _i18n.i18n.translate('xpack.onechat.conversation.rawResponseButton', {
  defaultMessage: 'View raw response'
});
const RoundThinking = ({
  steps,
  isLoading,
  rawRound
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const thinkingButtonStyles = (0, _react.css)`
    margin-right: ${euiTheme.size.xs};
    & .${buttonContentClassName} {
      /*
        From what I can tell this is by far the easiest solution to limit the content to one line.
        These CSS properties are supported by all modern browsers https://developer.mozilla.org/en-US/docs/Web/CSS/line-clamp
      */
      display: -webkit-box;
      -webkit-line-clamp: 1;
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
  `;
  const thinkingAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'roundThinkingAccordion'
  });
  const {
    agentReasoning
  } = (0, _send_message_context.useSendMessage)();
  const [showFlyout, setShowFlyout] = (0, _react2.useState)(false);
  if (steps.length === 0) {
    return null;
  }
  const accordionStyles = (0, _react.css)`
    .euiAccordion__children {
      padding: ${euiTheme.size.s} 0;
    }
  `;
  let thinkingButtonLabel = thinkingCompletedLabel;
  if (isLoading) {
    // While this round is loading, show the agent reasoning as the button label if available
    // Otherwise fallback to default thinking label.
    // Agent reasoning can be reasoning directly from the agent or individual tool call progression
    thinkingButtonLabel = agentReasoning !== null && agentReasoning !== void 0 ? agentReasoning : defaultThinkingLabel;
  }
  const toggleFlyout = () => {
    setShowFlyout(!showFlyout);
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: thinkingAccordionId,
    arrowDisplay: "left",
    css: accordionStyles,
    "data-test-subj": "agentBuilderThinkingToggle",
    buttonProps: {
      css: thinkingButtonStyles
    },
    buttonContent: thinkingButtonLabel,
    buttonContentClassName: buttonContentClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_round_steps.RoundSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), !isLoading && /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    iconType: 'code',
    color: "primary",
    iconSide: "left",
    onClick: toggleFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, rawResponseButtonLabel)), /*#__PURE__*/_react2.default.createElement(_round_flyout.RoundFlyout, {
    isOpen: showFlyout,
    onClose: toggleFlyout,
    rawRound: rawRound,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
exports.RoundThinking = RoundThinking;