"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.naturalLanguageSearch = void 0;
var _generate_esql = require("./generate_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const naturalLanguageSearch = async ({
  nlQuery,
  target,
  model,
  esClient,
  logger,
  events
}) => {
  const queryGenResponse = await (0, _generate_esql.generateEsql)({
    nlQuery,
    index: target,
    executeQuery: true,
    model,
    esClient,
    logger,
    events
  });
  return {
    generatedQuery: queryGenResponse.query,
    esqlData: queryGenResponse.results,
    error: queryGenResponse.error
  };
};
exports.naturalLanguageSearch = naturalLanguageSearch;