"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = DatePicker;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/annotations/date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DatePicker({
  start,
  end,
  setStart,
  setEnd,
  refetch
}) {
  const {
    uiSettings
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    css: {
      maxWidth: 500
    },
    onTimeChange: val => {
      setStart(val.start);
      setEnd(val.end);
    },
    start: start,
    end: end,
    onRefresh: val => {
      setStart(val.start);
      setEnd(val.end);
      refetch();
    },
    commonlyUsedRanges: uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('timepicker:quickRanges').map(({
      from,
      to,
      display
    }) => {
      return {
        start: from,
        end: to,
        label: display
      };
    }),
    updateButtonProps: {
      fill: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  });
}