"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationAppearance = AnnotationAppearance;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _react = _interopRequireDefault(require("react"));
var _forward_refs = require("./components/forward_refs");
var _text_decoration = require("./components/text_decoration");
var _fill_option = require("./components/fill_option");
var _icon_set = require("./icon_set");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/annotation_apearance.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AnnotationAppearance() {
  const {
    control,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const eventEnd = watch('event.end');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.appearance', {
    defaultMessage: 'Appearance'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }), eventEnd ? /*#__PURE__*/_react.default.createElement(_fill_option.FillOptions, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.markerIconLabel', {
      defaultMessage: 'Icon decoration'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "annotation.style.icon",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.IconSelect, {
      onChange: field.onChange,
      customIconSet: _icon_set.iconsSet,
      value: field.value,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 21
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "annotation.style.line.iconPosition",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_forward_refs.Select, (0, _extends2.default)({
      compressed: true,
      "data-test-subj": "o11yAnnotationAppearanceSelect"
    }, field, {
      options: [{
        value: 'top',
        text: 'Top'
      }, {
        value: 'bottom',
        text: 'Bottom'
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 21
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_text_decoration.TextDecoration, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "annotation.style.line",
    control: control,
    render: ({
      field,
      fieldState
    }) => {
      var _field$value, _field$value2;
      return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.LineStyleSettings, {
        currentConfig: {
          lineStyle: (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.style,
          lineWidth: (_field$value2 = field.value) === null || _field$value2 === void 0 ? void 0 : _field$value2.width
        },
        setConfig: newVal => {
          field.onChange({
            ...field.value,
            style: newVal.lineStyle,
            width: newVal.lineWidth
          });
        },
        idPrefix: "o11yAnnotations",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 15
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.lineStrokeColorLabel', {
      defaultMessage: 'Color'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "annotation.style.color",
    control: control,
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, (0, _extends2.default)({}, field, {
      color: field.value,
      compressed: true,
      showAlpha: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })));
}