"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKnowledgeBaseIndex = createKnowledgeBaseIndex;
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createKnowledgeBaseIndex({
  esClient,
  logger,
  indexName
}) {
  logger.debug(`Creating knowledge base write index "${indexName}"`);
  try {
    await esClient.asInternalUser.indices.create({
      index: indexName
    });
  } catch (error) {
    var _error$body, _error$body$error;
    if (error instanceof _elasticsearch.errors.ResponseError && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$error = _error$body.error) === null || _error$body$error === void 0 ? void 0 : _error$body$error.type) === 'resource_already_exists_exception') {
      throw new Error(`Write index "${indexName}" already exists. Please delete it before creating a new index.`);
    }
    logger.error(`Failed to create write index "${indexName}": ${error.message}`);
    throw error;
  }
}