"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSolutionSpecificLabels = getSolutionSpecificLabels;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns both breadcrumb text and page title for the given solution.
 *
 * Serverless deployments always use the generic breadcrumb "AI Assistant",
 * but keep solution-specific titles. Cloud deployments use solution-specific
 * values for both breadcrumb and page title.
 */
function getSolutionSpecificLabels({
  solution,
  isServerless
}) {
  let title;
  let breadcrumbText;
  switch (solution) {
    case 'oblt':
      title = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.title.observability', {
        defaultMessage: 'AI Assistant for Observability'
      });
      break;
    case 'es':
      title = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.title.search', {
        defaultMessage: 'AI Assistant for Search'
      });
      break;
    default:
      title = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.title.observabilityAndSearch', {
        defaultMessage: 'AI Assistant for Observability and Search'
      });
  }
  if (isServerless) {
    breadcrumbText = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.serverless', {
      defaultMessage: 'AI Assistant'
    });
  } else {
    switch (solution) {
      case 'oblt':
        breadcrumbText = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.observability', {
          defaultMessage: 'Observability'
        });
        break;
      case 'es':
        breadcrumbText = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.search', {
          defaultMessage: 'Search'
        });
        break;
      default:
        breadcrumbText = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.observabilityAndSearch', {
          defaultMessage: 'Observability and Search'
        });
    }
  }
  return {
    breadcrumbText,
    title
  };
}