"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BeatsTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _page_template = require("../page_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/beats/beats_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BeatsTemplate = ({
  instance,
  ...props
}) => {
  const tabs = [];
  if (!instance) {
    tabs.push({
      id: 'overview',
      label: _i18n.i18n.translate('xpack.monitoring.beatsNavigation.overviewLinkText', {
        defaultMessage: 'Overview'
      }),
      route: '/beats',
      testSubj: 'beatsOverviewPage'
    });
    tabs.push({
      id: 'instances',
      label: _i18n.i18n.translate('xpack.monitoring.beatsNavigation.instancesLinkText', {
        defaultMessage: 'Instances'
      }),
      route: '/beats/beats',
      testSubj: 'beatsListingPage'
    });
  } else {
    tabs.push({
      id: 'overview',
      label: _i18n.i18n.translate('xpack.monitoring.beatsNavigation.instance.overviewLinkText', {
        defaultMessage: 'Overview'
      }),
      route: `/beats/beat/${instance}`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, props, {
    tabs: tabs,
    product: "beats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 10
    }
  }));
};
exports.BeatsTemplate = BeatsTemplate;