"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartActionModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_start/start_action_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StartActionModal = ({
  closeModal,
  item,
  startAndCloseModal
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, item !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startModalTitle', {
      defaultMessage: 'Start {analyticsId}?',
      values: {
        analyticsId: item.config.id
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeModal,
    onConfirm: startAndCloseModal,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startModalStartButton', {
      defaultMessage: 'Start'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startModalBody', {
    defaultMessage: 'A data frame analytics job increases search and indexing load in your cluster. If excessive load occurs, stop the job.'
  }))));
};
exports.StartActionModal = StartActionModal;