"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkTrafficWithInterfacesWithFilter = exports.networkTrafficWithInterfaces = exports.networkTraffic = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const networkTraffic = (id, field) => {
  return {
    [`${id}_max`]: {
      max: {
        field
      }
    },
    [`${id}_deriv`]: {
      derivative: {
        buckets_path: `${id}_max`,
        gap_policy: 'skip',
        unit: '1s'
      }
    },
    [id]: {
      bucket_script: {
        buckets_path: {
          value: `${id}_deriv[normalized_value]`
        },
        script: {
          source: 'params.value > 0.0 ? params.value : 0.0',
          lang: 'painless'
        },
        gap_policy: 'skip'
      }
    }
  };
};
exports.networkTraffic = networkTraffic;
const networkTrafficWithInterfaces = (id, metricField, interfaceField) => ({
  [`${id}_interfaces`]: {
    terms: {
      field: interfaceField
    },
    aggregations: {
      [`${id}_interface_max`]: {
        max: {
          field: metricField
        }
      }
    }
  },
  [`${id}_sum_of_interfaces`]: {
    sum_bucket: {
      buckets_path: `${id}_interfaces>${id}_interface_max`
    }
  },
  [`${id}_deriv`]: {
    derivative: {
      buckets_path: `${id}_sum_of_interfaces`,
      gap_policy: 'skip',
      unit: '1s'
    }
  },
  [id]: {
    bucket_script: {
      buckets_path: {
        value: `${id}_deriv[normalized_value]`
      },
      script: {
        source: 'params.value > 0.0 ? params.value : 0.0',
        lang: 'painless'
      },
      gap_policy: 'skip'
    }
  }
});
exports.networkTrafficWithInterfaces = networkTrafficWithInterfaces;
const networkTrafficWithInterfacesWithFilter = (id, metricField, interfaceField, filter) => ({
  [`${id}_dimension`]: {
    filter,
    aggs: {
      [`${id}_interfaces`]: {
        terms: {
          field: interfaceField
        },
        aggregations: {
          [`${id}_interface_max`]: {
            max: {
              field: metricField
            }
          }
        }
      },
      [`${id}_sum_of_interfaces`]: {
        sum_bucket: {
          buckets_path: `${id}_interfaces>${id}_interface_max`
        }
      }
    }
  },
  [`${id}_deriv`]: {
    derivative: {
      buckets_path: `${id}_dimension>${id}_sum_of_interfaces`,
      gap_policy: 'skip',
      unit: '1s'
    }
  },
  [id]: {
    bucket_script: {
      buckets_path: {
        value: `${id}_deriv[normalized_value]`
      },
      script: {
        source: 'params.value > 0.0 ? params.value : 0.0',
        lang: 'painless'
      },
      gap_policy: 'skip'
    }
  }
});
exports.networkTrafficWithInterfacesWithFilter = networkTrafficWithInterfacesWithFilter;