"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dockerContainerDiskIOWrite = exports.dockerContainerDiskIORead = void 0;
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dockerContainerDiskIORead = exports.dockerContainerDiskIORead = {
  label: _constants.DISK_READ_IOPS_LABEL,
  value: "counter_rate(max(docker.diskio.read.ops), kql='docker.diskio.read.ops: *')",
  format: 'number',
  decimals: 0,
  normalizeByUnit: 's'
};
const dockerContainerDiskIOWrite = exports.dockerContainerDiskIOWrite = {
  label: _constants.DISK_WRITE_IOPS_LABEL,
  value: "counter_rate(max(docker.diskio.write.ops), kql='docker.diskio.write.ops: *')",
  format: 'number',
  decimals: 0,
  normalizeByUnit: 's'
};