"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPanelPlacement = getPanelPlacement;
var _public = require("@kbn/dashboard-plugin/public");
var _content_management = require("../../common/content_management");
var _load_from_library = require("../content_management/load_from_library");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getPanelPlacement(serializedState) {
  if (!serializedState) return {};
  let layout = _content_management.LINKS_HORIZONTAL_LAYOUT;
  let numLinks = 1;
  try {
    const savedObjectId = serializedState.rawState.savedObjectId;
    const linksState = savedObjectId ? await (0, _load_from_library.loadFromLibrary)(savedObjectId) : serializedState.rawState;
    if (linksState.layout) layout = linksState.layout;
    if (linksState.links) numLinks = linksState.links.length;
  } catch (error) {
    // ignore saved object load error and just use default values
  }
  const isHorizontal = layout === _content_management.LINKS_HORIZONTAL_LAYOUT;
  const width = isHorizontal ? _public.DASHBOARD_GRID_COLUMN_COUNT : 8;
  const height = isHorizontal ? 4 : numLinks * 3 + 4;
  return {
    width,
    height,
    strategy: _public.PanelPlacementStrategy.placeAtTop
  };
}