"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onSave = exports.getSaveLayerAction = exports.SaveModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _eui = require("@elastic/eui");
var _visualization_helpers = require("../../visualization_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/annotations/actions/save_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** @internal exported for testing only */
const SaveModal = ({
  domElement,
  savedObjectsTagging,
  onSave,
  title,
  description,
  tags,
  showCopyOnSave
}) => {
  const [selectedTags, setSelectedTags] = (0, _react.useState)(tags);
  const closeModal = () => (0, _reactDom.unmountComponentAtNode)(domElement);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    onSave: async props => {
      await onSave({
        ...props,
        closeModal,
        newTags: selectedTags
      });
    },
    onClose: closeModal,
    title: title,
    description: description,
    showCopyOnSave: showCopyOnSave,
    objectType: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.objectType', {
      defaultMessage: 'group'
    }),
    customModalTitle: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.modalTitle', {
      defaultMessage: 'Save annotation group to library'
    }),
    showDescription: true,
    confirmButtonLabel: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "save",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.confirmButton', {
      defaultMessage: 'Save group'
    }))),
    options: savedObjectsTagging ? /*#__PURE__*/_react.default.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector, {
      initialSelection: selectedTags,
      onTagsSelected: setSelectedTags,
      markOptional: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};
exports.SaveModal = SaveModal;
const saveAnnotationGroupToLibrary = async (layer, {
  newTitle,
  newDescription,
  newTags,
  newCopyOnSave
}, eventAnnotationService, dataViews) => {
  let savedId;
  const dataView = await dataViews.get(layer.indexPatternId);
  const saveAsNew = !(0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer) || newCopyOnSave;
  const groupConfig = {
    annotations: layer.annotations,
    indexPatternId: layer.indexPatternId,
    ignoreGlobalFilters: layer.ignoreGlobalFilters,
    title: newTitle,
    description: newDescription,
    tags: newTags,
    dataViewSpec: dataView.isPersisted() ? undefined : dataView.toSpec(false)
  };
  if (saveAsNew) {
    const {
      id
    } = await eventAnnotationService.createAnnotationGroup(groupConfig);
    savedId = id;
  } else {
    await eventAnnotationService.updateAnnotationGroup(groupConfig, layer.annotationGroupId);
    savedId = layer.annotationGroupId;
  }
  return {
    id: savedId,
    config: groupConfig
  };
};
const shouldStopBecauseDuplicateTitle = async (newTitle, existingTitle, newCopyOnSave, onTitleDuplicate, isTitleDuplicateConfirmed, eventAnnotationService) => {
  if (isTitleDuplicateConfirmed || newTitle === existingTitle && !newCopyOnSave) {
    return false;
  }
  const duplicateExists = await eventAnnotationService.groupExistsWithTitle(newTitle);
  if (duplicateExists) {
    onTitleDuplicate();
    return true;
  } else {
    return false;
  }
};

/** @internal exported for testing only */
const onSave = async ({
  state,
  layer,
  setState,
  registerLibraryAnnotationGroup,
  eventAnnotationService,
  toasts,
  modalOnSaveProps: {
    newTitle,
    newDescription,
    newTags,
    closeModal,
    newCopyOnSave,
    onTitleDuplicate,
    isTitleDuplicateConfirmed
  },
  dataViews,
  goToAnnotationLibrary,
  startServices
}) => {
  const shouldStop = await shouldStopBecauseDuplicateTitle(newTitle, (0, _visualization_helpers.getAnnotationLayerTitle)(layer), newCopyOnSave, onTitleDuplicate, isTitleDuplicateConfirmed, eventAnnotationService);
  if (shouldStop) return;
  let savedInfo;
  try {
    savedInfo = await saveAnnotationGroupToLibrary(layer, {
      newTitle,
      newDescription,
      newTags,
      newCopyOnSave
    }, eventAnnotationService, dataViews);

    // add new group to state
    registerLibraryAnnotationGroup({
      id: savedInfo.id,
      group: savedInfo.config
    });
  } catch (err) {
    toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.errorToastTitle', {
        defaultMessage: 'Failed to save "{title}"',
        values: {
          title: newTitle
        }
      })
    });
    return;
  }
  const newLayer = {
    ...layer,
    annotationGroupId: savedInfo.id,
    __lastSaved: savedInfo.config
  };
  setState({
    ...state,
    layers: state.layers.map(existingLayer => existingLayer.layerId === newLayer.layerId ? newLayer : existingLayer)
  });
  closeModal();
  toasts.addSuccess({
    title: _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.successToastTitle', {
      defaultMessage: 'Saved "{title}"',
      values: {
        title: newTitle
      }
    }),
    text: element => (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.successToastBody",
      defaultMessage: "View or manage in the {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "lnsAnnotationLibraryLink",
          onClick: () => goToAnnotationLibrary(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 279,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary.annotationLibrary', {
          defaultMessage: 'annotation library'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 11
      }
    })), element)
  });
};
exports.onSave = onSave;
const getSaveLayerAction = ({
  state,
  layer,
  setState,
  registerLibraryAnnotationGroup,
  eventAnnotationService,
  toasts,
  savedObjectsTagging,
  dataViews,
  goToAnnotationLibrary,
  startServices
}) => {
  const neverSaved = !(0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer);
  const displayName = _i18n.i18n.translate('xpack.lens.xyChart.annotations.saveAnnotationGroupToLibrary', {
    defaultMessage: 'Save to library'
  });
  return {
    displayName,
    description: _i18n.i18n.translate('xpack.lens.xyChart.annotations.addAnnotationGroupToLibraryDescription', {
      defaultMessage: 'Saves annotation group as separate saved object'
    }),
    execute: async domElement => {
      if (domElement) {
        const metadata = (0, _visualization_helpers.getGroupMetadataFromAnnotationLayer)(layer);
        (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 342,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(SaveModal, (0, _extends2.default)({
          domElement: domElement,
          savedObjectsTagging: savedObjectsTagging,
          onSave: async props => {
            await onSave({
              state,
              layer,
              setState,
              registerLibraryAnnotationGroup,
              eventAnnotationService,
              toasts,
              modalOnSaveProps: props,
              dataViews,
              goToAnnotationLibrary,
              startServices
            });
          }
        }, metadata, {
          showCopyOnSave: !neverSaved,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 343,
            columnNumber: 13
          }
        }))), domElement);
      }
    },
    icon: 'save',
    isCompatible: true,
    'data-test-subj': 'lnsXY_annotationLayer_saveToLibrary',
    order: 100,
    showOutsideList: true
  };
};
exports.getSaveLayerAction = getSaveLayerAction;