"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _inspector_view_chooser = require("./inspector_view_chooser");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/ui/inspector_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function hasAdaptersChanged(oldAdapters, newAdapters) {
  return Object.keys(oldAdapters).length !== Object.keys(newAdapters).length || Object.keys(oldAdapters).some(key => oldAdapters[key] !== newAdapters[key]);
}
const inspectorTitle = _i18n.i18n.translate('inspector.title', {
  defaultMessage: 'Inspector'
});
class InspectorPanel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      selectedView: this.props.views[0],
      views: this.props.views,
      // Clone adapters array so we can validate that this prop never change
      adapters: {
        ...this.props.adapters
      }
    });
    (0, _defineProperty2.default)(this, "onViewSelected", view => {
      if (view !== this.state.selectedView) {
        this.setState({
          selectedView: view
        });
      }
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (hasAdaptersChanged(prevState.adapters, nextProps.adapters)) {
      throw new Error('Adapters are not allowed to be changed on an open InspectorPanel.');
    }
    const selectedViewMustChange = nextProps.views !== prevState.views && !nextProps.views.includes(prevState.selectedView);
    return {
      views: nextProps.views,
      selectedView: selectedViewMustChange ? nextProps.views[0] : prevState.selectedView
    };
  }
  renderSelectedPanel() {
    return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 27
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(this.state.selectedView.component, {
      adapters: this.props.adapters,
      title: this.props.title || '',
      options: this.props.options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }));
  }
  render() {
    const {
      views,
      title,
      dependencies
    } = this.props;
    const {
      selectedView
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: dependencies,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      id: "inspector-panel-title",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_inspector_view_chooser.InspectorViewChooser, {
      views: views,
      onViewSelected: this.onViewSelected,
      selectedView: selectedView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      css: (0, _react2.css)({
        '.euiFlyoutBody__overflowContent': {
          height: '100%',
          display: 'flex',
          flexWrap: 'nowrap',
          flexDirection: 'column',
          '> div': {
            flexGrow: 0
          },
          '.insRequestCodeViewer': {
            flexGrow: 1
          }
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, this.renderSelectedPanel()));
  }
}
exports.InspectorPanel = InspectorPanel;
(0, _defineProperty2.default)(InspectorPanel, "defaultProps", {
  title: inspectorTitle
});
(0, _defineProperty2.default)(InspectorPanel, "propTypes", {
  adapters: _propTypes.default.object.isRequired,
  views: (props, propName, componentName) => {
    if (!Array.isArray(props.views) || props.views.length < 1) {
      throw new Error(`${propName} prop must be an array of at least one element in ${componentName}.`);
    }
  },
  title: _propTypes.default.string,
  options: _propTypes.default.object
});