"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _auto_sizer = require("../../../../components/auto_sizer");
var _nodes_overview = require("./nodes_overview");
var _calculate_bounds_from_nodes = require("../lib/calculate_bounds_from_nodes");
var _page = require("../../../../components/page");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _types = require("../../../../common/inventory/types");
var _toolbar = require("./toolbars/toolbar");
var _view_switcher = require("./waffle/view_switcher");
var _create_inventory_metric_formatter = require("../lib/create_inventory_metric_formatter");
var _create_legend = require("../lib/create_legend");
var _bottom_drawer = require("./bottom_drawer");
var _legend_controls = require("./waffle/legend_controls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Layout = exports.Layout = /*#__PURE__*/_react.default.memo(({
  interval,
  nodes,
  loading
}) => {
  var _legend$palette, _legend$steps, _legend$reverseColors;
  const [showLoading, setShowLoading] = (0, _react.useState)(true);
  const {
    metric,
    groupBy,
    sort,
    nodeType,
    changeView,
    view,
    autoBounds,
    boundsOverride,
    legend,
    changeBoundsOverride,
    changeAutoBounds,
    changeLegend
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    jumpToTime,
    isAutoReloading
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    applyFilterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const legendPalette = (_legend$palette = legend === null || legend === void 0 ? void 0 : legend.palette) !== null && _legend$palette !== void 0 ? _legend$palette : _use_waffle_options.DEFAULT_LEGEND.palette;
  const legendSteps = (_legend$steps = legend === null || legend === void 0 ? void 0 : legend.steps) !== null && _legend$steps !== void 0 ? _legend$steps : _use_waffle_options.DEFAULT_LEGEND.steps;
  const legendReverseColors = (_legend$reverseColors = legend === null || legend === void 0 ? void 0 : legend.reverseColors) !== null && _legend$reverseColors !== void 0 ? _legend$reverseColors : _use_waffle_options.DEFAULT_LEGEND.reverseColors;
  const AUTO_REFRESH_INTERVAL = 5 * 1000;
  const options = {
    formatter: _types.InfraFormatterType.percent,
    formatTemplate: '{{value}}',
    legend: (0, _create_legend.createLegend)(legendPalette, legendSteps, legendReverseColors),
    metric,
    sort,
    groupBy
  };
  (0, _useInterval.default)(() => {
    if (!loading) {
      jumpToTime(Date.now());
    }
  }, isAutoReloading ? AUTO_REFRESH_INTERVAL : null);
  const dataBounds = (0, _calculate_bounds_from_nodes.calculateBoundsFromNodes)(nodes);
  const bounds = autoBounds ? dataBounds : boundsOverride;
  const formatter = (0, _react.useCallback)(val => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)(options.metric)(val), [options.metric]);
  const onDrilldown = (0, _react.useCallback)(expression => {
    applyFilterQuery({
      query: {
        language: 'kuery',
        query: expression
      }
    });
  }, [applyFilterQuery]);
  (0, _react.useEffect)(() => {
    setShowLoading(true);
  }, [options.metric, nodeType]);
  (0, _react.useEffect)(() => {
    const hasNodes = nodes && nodes.length;
    // Don't show loading screen when we're auto-reloading
    setShowLoading(!hasNodes);
  }, [nodes]);
  const handleLegendControlChange = (0, _react.useCallback)(opts => {
    changeBoundsOverride(opts.bounds);
    changeAutoBounds(opts.auto);
    changeLegend(opts.legend);
  }, [changeBoundsOverride, changeAutoBounds, changeLegend]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page.PageContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(TopActionContainer, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    nodeType: nodeType,
    currentTime: currentTime,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    css: (0, _react2.css)`
                  margin: 0;
                  justify-content: flex-end;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, view === 'map' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_legend_controls.LegendControls, {
    options: legend != null ? legend : _use_waffle_options.DEFAULT_LEGEND,
    dataBounds: dataBounds,
    bounds: bounds,
    autoBounds: autoBounds,
    boundsOverride: boundsOverride,
    onChange: handleLegendControlChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_view_switcher.ViewSwitcher, {
    view: view,
    onChange: changeView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
              position: relative;
              flex: 1 1 auto;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
    bounds: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, ({
    bounds: {
      height = 0
    }
  }) => /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesOverview, {
    nodes: nodes,
    options: options,
    nodeType: nodeType,
    loading: loading,
    showLoading: showLoading,
    onDrilldown: onDrilldown,
    currentTime: currentTime,
    view: view,
    autoBounds: autoBounds,
    boundsOverride: boundsOverride,
    formatter: formatter,
    bottomMargin: height,
    isAutoReloading: isAutoReloading,
    refreshInterval: AUTO_REFRESH_INTERVAL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_bottom_drawer.BottomDrawer, {
    interval: interval,
    formatter: formatter,
    view: view,
    nodeType: nodeType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }));
});
const TopActionContainer = (0, _styled.default)(_eui.EuiFlexItem)`
  padding: ${props => `${props.theme.euiTheme.size.m} 0`};
`;