"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryRateSetupView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _initial_configuration_step = require("../initial_configuration_step");
var _process_step = require("../process_step");
var _log_entry_rate = require("../../../../containers/logs/log_analysis/modules/log_entry_rate");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/setup_flyout/log_entry_rate_setup_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogEntryRateSetupView = ({
  onClose
}) => {
  const {
    cleanUpAndSetUp,
    endTime,
    isValidating,
    lastSetupErrorMessages,
    moduleDescriptor,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    setupStatus,
    startTime,
    validatedIndices,
    validationErrors,
    viewResults
  } = (0, _log_entry_rate.useLogEntryRateSetup)();
  const viewResultsAndClose = (0, _react.useCallback)(() => {
    viewResults();
    onClose();
  }, [viewResults, onClose]);
  const steps = (0, _react.useMemo)(() => [(0, _initial_configuration_step.createInitialConfigurationStep)({
    setStartTime,
    setEndTime,
    startTime,
    endTime,
    isValidating,
    validatedIndices,
    setupStatus,
    setValidatedIndices,
    validationErrors
  }), (0, _process_step.createProcessStep)({
    cleanUpAndSetUp,
    errorMessages: lastSetupErrorMessages,
    isConfigurationValid: validationErrors.length <= 0 && !isValidating,
    setUp,
    setupStatus,
    viewResults: viewResultsAndClose
  })], [cleanUpAndSetUp, endTime, isValidating, lastSetupErrorMessages, setEndTime, setStartTime, setUp, setValidatedIndices, setupStatus, startTime, validatedIndices, validationErrors, viewResultsAndClose]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, moduleDescriptor.moduleName, " ")), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, moduleDescriptor.moduleDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
};
exports.LogEntryRateSetupView = LogEntryRateSetupView;