"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecreateJobButton = exports.CreateJobButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _missing_setup_privileges_tooltip = require("./missing_setup_privileges_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/create_job_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateJobButton = ({
  hasSetupCapabilities = true,
  children,
  ...buttonProps
}) => {
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "infraCreateJobButtonButton",
    isDisabled: !hasSetupCapabilities
  }, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }), children !== null && children !== void 0 ? children : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.createJobButtonLabel",
    defaultMessage: "Create ML jobs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }));
  return hasSetupCapabilities ? button : /*#__PURE__*/_react.default.createElement(_missing_setup_privileges_tooltip.MissingSetupPrivilegesToolTip, {
    position: "bottom",
    delay: "regular",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, button);
};
exports.CreateJobButton = CreateJobButton;
const RecreateJobButton = ({
  children,
  ...otherProps
}) => /*#__PURE__*/_react.default.createElement(CreateJobButton, (0, _extends2.default)({}, otherProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 3
  }
}), children !== null && children !== void 0 ? children : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.analysis.recreateJobButtonLabel",
  defaultMessage: "Recreate ML job",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 7
  }
}));
exports.RecreateJobButton = RecreateJobButton;