"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorList = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorList = async ({
  actions,
  request
}) => {
  const actionClient = await actions.getActionsClientWithRequest(request);
  const allConnectors = await actionClient.getAll({
    includeSystemActions: false
  });
  return allConnectors.filter(connector => (0, _inferenceCommon.isSupportedConnector)(connector)).map(_inferenceCommon.connectorToInference);
};
exports.getConnectorList = getConnectorList;