"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Shrink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n_texts = require("../../../edit_policy/i18n_texts");
var _i18n_texts2 = require("./i18n_texts");
var _action_description = require("./action_description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/policy_flyout/components/shrink.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Shrink = ({
  phase,
  phases
}) => {
  const phaseConfig = phases[phase];
  const shrink = phaseConfig === null || phaseConfig === void 0 ? void 0 : phaseConfig.actions.shrink;
  const descriptionItems = [];
  if (shrink !== null && shrink !== void 0 && shrink.number_of_shards) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.shrinkNumberOfShardsLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }, shrink.number_of_shards)));
  }
  if (shrink !== null && shrink !== void 0 && shrink.max_primary_shard_size) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.maxPrimaryShardSizeLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, shrink.max_primary_shard_size)));
  }
  descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.allowWriteAfterShrinkLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, shrink !== null && shrink !== void 0 && shrink.allow_write_after_shrink ? _i18n_texts2.i18nTexts.yes : _i18n_texts2.i18nTexts.no)));
  return shrink ? /*#__PURE__*/_react.default.createElement(_action_description.ActionDescription, {
    title: _i18n_texts.i18nTexts.editPolicy.shrinkActionLabel,
    descriptionItems: descriptionItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }) : null;
};
exports.Shrink = Shrink;