"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GoToSpacesButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/go_to_spaces_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GoToSpacesButton = ({
  onNavigateToSpaces,
  navigateToPermissions = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    iconSide: "right",
    "data-test-subj": navigateToPermissions ? 'goToPermissionsTabButton' : 'goToSpacesButton',
    onClick: onNavigateToSpaces,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: navigateToPermissions ? 'genAiSettings.goToPermissionsTabButtonLabel' : 'genAiSettings.goToSpacesButtonLabel',
    defaultMessage: navigateToPermissions ? 'Go to Permissions tab' : 'Go to Space Settings',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
};
exports.GoToSpacesButton = GoToSpacesButton;