"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _agent_policy = require("./agent_policy");
var _package_policy = require("./package_policy");
var _data_streams = require("./data_streams");
var _epm = require("./epm");
var _setup = require("./setup");
var _agent = require("./agent");
var _enrollment_api_key = require("./enrollment_api_key");
var _output = require("./output");
var _settings = require("./settings");
var _app = require("./app");
var _preconfiguration = require("./preconfiguration");
var _download_source = require("./download_source");
var _health_check = require("./health_check");
var _fleet_server_hosts = require("./fleet_server_hosts");
var _fleet_proxies = require("./fleet_proxies");
var _message_signing_service = require("./message_signing_service");
var _uninstall_token = require("./uninstall_token");
var _standalone_agent_api_key = require("./standalone_agent_api_key");
var _debug = require("./debug");
var _remote_synced_integrations = require("./remote_synced_integrations");
var _cloud_connector = require("./cloud_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoutes(fleetAuthzRouter, config, isServerless) {
  // Always register app routes for permissions checking
  (0, _app.registerRoutes)(fleetAuthzRouter, config, isServerless);

  // The upload package route is only authorized for the superuser
  (0, _epm.registerRoutes)(fleetAuthzRouter, config);
  (0, _setup.registerRoutes)(fleetAuthzRouter, config);
  (0, _agent_policy.registerRoutes)(fleetAuthzRouter, config);
  (0, _package_policy.registerRoutes)(fleetAuthzRouter);
  (0, _output.registerRoutes)(fleetAuthzRouter);
  (0, _settings.registerRoutes)(fleetAuthzRouter, config);
  (0, _data_streams.registerRoutes)(fleetAuthzRouter);
  (0, _preconfiguration.registerRoutes)(fleetAuthzRouter);
  (0, _fleet_server_hosts.registerRoutes)(fleetAuthzRouter);
  (0, _fleet_proxies.registerRoutes)(fleetAuthzRouter);
  (0, _download_source.registerRoutes)(fleetAuthzRouter);
  (0, _health_check.registerRoutes)(fleetAuthzRouter);
  (0, _message_signing_service.registerRoutes)(fleetAuthzRouter);
  (0, _uninstall_token.registerRoutes)(fleetAuthzRouter, config);
  (0, _standalone_agent_api_key.registerRoutes)(fleetAuthzRouter);
  (0, _remote_synced_integrations.registerRoutes)(fleetAuthzRouter, isServerless);
  (0, _debug.registerRoutes)(fleetAuthzRouter);
  (0, _cloud_connector.registerRoutes)(fleetAuthzRouter);

  // Conditional config routes
  if (config.agents.enabled) {
    (0, _agent.registerAPIRoutes)(fleetAuthzRouter, config);
    (0, _enrollment_api_key.registerRoutes)(fleetAuthzRouter);
  }
}