"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledPackages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _hooks = require("../../../../hooks");
var _package_list_grid = require("../../components/package_list_grid");
var _constants2 = require("../../../../../../../common/constants");
var _category_facets = require("./category_facets");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/home/installed_packages.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnnouncementLink = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.learnMoreBlog,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.fleet.epmList.availableCalloutBlogText', {
    defaultMessage: 'announcement blog post'
  }));
};
const InstalledIntegrationsInfoCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.fleet.epmList.availableCalloutTitle', {
    defaultMessage: 'Only installed Elastic Agent Integrations are displayed.'
  }),
  iconType: "info",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epmList.availableCalloutIntroText",
  defaultMessage: "To learn more about integrations and the Elastic Agent, read our {link}",
  values: {
    link: /*#__PURE__*/_react.default.createElement(AnnouncementLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 17
      }
    })
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 7
  }
})));
const UpdatesAvailableCallout = ({
  count
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.fleet.epmList.updatesAvailableCalloutTitle', {
    defaultMessage: '{count, number} of your installed integrations {count, plural, one {has an update} other {have updates}} available.',
    values: {
      count
    }
  }),
  iconType: "warning",
  color: "warning",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epmList.updatesAvailableCalloutText",
  defaultMessage: "Update your integrations to get the latest features.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 7
  }
})));
const VerificationWarningCallout = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.epmList.verificationWarningCalloutTitle', {
      defaultMessage: 'Integrations not verified'
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmList.verificationWarningCalloutIntroText",
    defaultMessage: "One or more of the installed integrations contain an unsigned package of unknown authenticity. Learn more about {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.packageSignatures,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.ConfirmForceInstallModal.learnMoreLink",
        defaultMessage: "package signatures",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })));
};
const InstalledPackages = ({
  installedPackages,
  isLoading
}) => {
  (0, _hooks.useBreadcrumbs)('integrations_installed');
  const {
    packageVerificationKeyId
  } = (0, _hooks.useGetPackageVerificationKeyId)();
  const {
    getHref,
    getAbsolutePath
  } = (0, _hooks.useLink)();
  const {
    selectedCategory: initialSelectedCategory,
    searchParam
  } = (0, _.getParams)((0, _reactRouterDom.useParams)(), (0, _reactRouterDom.useLocation)().search);
  const [selectedCategory, setCategory] = (0, _react.useState)(initialSelectedCategory);
  const [searchTerm, setSearchTerm] = (0, _react.useState)(searchParam || '');
  const {
    http
  } = (0, _hooks.useStartServices)();
  const addBasePath = http.basePath.prepend;
  const history = (0, _reactRouterDom.useHistory)();
  const buildUrl = ({
    searchString,
    categoryId,
    subCategoryId
  }) => {
    const url = _constants.pagePathGetters.integrations_installed({
      category: categoryId ? categoryId : '',
      query: searchString ? searchString : ''
    })[1];
    return url;
  };
  const setUrlandPushHistory = ({
    searchString,
    categoryId
  }) => {
    const url = buildUrl({
      categoryId,
      searchString
    });
    history.push(url);
  };
  const setUrlandReplaceHistory = ({
    searchString,
    categoryId
  }) => {
    const url = buildUrl({
      categoryId,
      searchString
    });
    // Use .replace so the browser's back button is not tied to single keystroke
    history.replace(url);
  };
  const updatablePackages = (0, _react.useMemo)(() => installedPackages.filter(item => {
    var _item$installationInf;
    return (item === null || item === void 0 ? void 0 : (_item$installationInf = item.installationInfo) === null || _item$installationInf === void 0 ? void 0 : _item$installationInf.version) && (0, _lt.default)(item.installationInfo.version, item.version);
  }), [installedPackages]);

  // Todo move to another place
  const installationFailedPackages = (0, _react.useMemo)(() => installedPackages.filter(item => {
    var _item$installationInf2;
    return (item === null || item === void 0 ? void 0 : (_item$installationInf2 = item.installationInfo) === null || _item$installationInf2 === void 0 ? void 0 : _item$installationInf2.install_status) === _constants2.installationStatuses.InstallFailed;
  }), [installedPackages]);
  const updateFailedPackages = (0, _react.useMemo)(() => installedPackages.filter(item => {
    var _item$installationInf3, _item$installationInf4;
    return item === null || item === void 0 ? void 0 : (_item$installationInf3 = item.installationInfo) === null || _item$installationInf3 === void 0 ? void 0 : (_item$installationInf4 = _item$installationInf3.latest_install_failed_attempts) === null || _item$installationInf4 === void 0 ? void 0 : _item$installationInf4.some(attempt => item.installationInfo && (0, _lt.default)(item.installationInfo.version, attempt.target_version));
  }), [installedPackages]);
  const categories = (0, _react.useMemo)(() => [{
    ..._category_facets.ALL_INSTALLED_CATEGORY,
    count: installedPackages.length
  }, {
    ..._category_facets.UPDATES_AVAILABLE_CATEGORY,
    count: updatablePackages.length
  }, {
    ..._category_facets.UPDATE_FAILED_CATEGORY,
    count: updateFailedPackages.length
  }, {
    ..._category_facets.INSTALL_FAILED_CATEGORY,
    count: installationFailedPackages.length
  }], [installedPackages.length, updatablePackages.length, installationFailedPackages.length, updateFailedPackages.length]);
  const cards = (0, _react.useMemo)(() => {
    let packages;
    if (selectedCategory === _category_facets.UPDATES_AVAILABLE) {
      packages = updatablePackages;
    } else if (selectedCategory === _category_facets.INSTALL_FAILED) {
      packages = installationFailedPackages;
    } else if (selectedCategory === _category_facets.UPDATE_FAILED) {
      packages = updateFailedPackages;
    } else {
      packages = installedPackages;
    }
    return packages.map(item => (0, _.mapToCard)({
      getAbsolutePath,
      getHref,
      addBasePath,
      item,
      selectedCategory: selectedCategory || 'installed',
      packageVerificationKeyId
    }));
  }, [selectedCategory, updatablePackages, installedPackages, updateFailedPackages, installationFailedPackages, packageVerificationKeyId, addBasePath, getHref, getAbsolutePath]);
  if (!(0, _.categoryExists)(selectedCategory, categories)) {
    setUrlandReplaceHistory({
      searchString: searchTerm,
      categoryId: ''
    });
    return null;
  }
  let CalloutComponent = /*#__PURE__*/_react.default.createElement(InstalledIntegrationsInfoCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 26
    }
  });
  const unverifiedCount = cards.filter(c => c.isUnverified).length;
  const updateAvailableCount = cards.filter(c => c.isUpdateAvailable).length;
  if (unverifiedCount) {
    CalloutComponent = /*#__PURE__*/_react.default.createElement(VerificationWarningCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 24
      }
    });
  } else if (updateAvailableCount) {
    CalloutComponent = /*#__PURE__*/_react.default.createElement(UpdatesAvailableCallout, {
      count: updateAvailableCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 24
      }
    });
  }
  const callout = selectedCategory !== '' || isLoading ? null : CalloutComponent;
  return /*#__PURE__*/_react.default.createElement(_package_list_grid.PackageListGrid, {
    isLoading,
    callout,
    categories,
    controls: /*#__PURE__*/_react.default.createElement(_category_facets.CategoryFacets, {
      categories: categories,
      selectedCategory: selectedCategory,
      onCategoryChange: ({
        id
      }) => {
        setCategory(id);
        setSearchTerm('');
        setUrlandPushHistory({
          searchString: '',
          categoryId: id
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 9
      }
    }),
    selectedCategory: selectedCategory,
    setCategory: setCategory,
    setUrlandPushHistory: setUrlandPushHistory,
    setUrlandReplaceHistory: setUrlandReplaceHistory,
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    list: cards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 5
    }
  });
};
exports.InstalledPackages = InstalledPackages;