"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostInstallGoogleCloudShellModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../../../../hooks");
var _enrollment_instructions = require("../../../../../../../../components/enrollment_instructions");
var _cloud_security_posture = require("../../../../../../../../components/cloud_security_posture");
var _hooks2 = require("../../../../../../../../components/cloud_security_posture/hooks");
var _services = require("../../../../../../../../components/cloud_security_posture/services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/single_page_layout/components/cloud_security_posture/post_install_google_cloud_shell_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PostInstallGoogleCloudShellModal = ({
  onConfirm,
  onCancel,
  agentPolicy,
  packagePolicy
}) => {
  var _apyKeysData$data, _apyKeysData$data$ite, _apyKeysData$data2, _apyKeysData$data2$it;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    data: apyKeysData
  } = (0, _reactQuery.useQuery)(['googleCloudShellApiKeys'], () => (0, _hooks.sendGetEnrollmentAPIKeys)({
    page: 1,
    perPage: 1,
    kuery: `policy_id:"${agentPolicy.id}"`
  }));
  const {
    fleetServerHost,
    fleetProxy,
    downloadSource
  } = (0, _hooks.useFleetServerHostsForPolicy)(agentPolicy);
  const agentVersion = (0, _hooks.useAgentVersion)();
  const {
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType
  } = (0, _services.getGcpIntegrationDetailsFromPackagePolicy)(packagePolicy);
  const {
    cloudShellUrl,
    error,
    isError,
    isLoading
  } = (0, _hooks2.useCreateCloudShellUrl)({
    enrollmentAPIKey: apyKeysData === null || apyKeysData === void 0 ? void 0 : (_apyKeysData$data = apyKeysData.data) === null || _apyKeysData$data === void 0 ? void 0 : (_apyKeysData$data$ite = _apyKeysData$data.items[0]) === null || _apyKeysData$data$ite === void 0 ? void 0 : _apyKeysData$data$ite.api_key,
    packagePolicy
  });
  if (!agentVersion) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 12
      }
    });
  }
  const installManagedCommands = (0, _enrollment_instructions.ManualInstructions)({
    apiKey: (apyKeysData === null || apyKeysData === void 0 ? void 0 : (_apyKeysData$data2 = apyKeysData.data) === null || _apyKeysData$data2 === void 0 ? void 0 : (_apyKeysData$data2$it = _apyKeysData$data2.items[0]) === null || _apyKeysData$data2$it === void 0 ? void 0 : _apyKeysData$data2$it.api_key) || 'no_key',
    fleetServerHost,
    fleetProxy,
    downloadSource,
    agentVersion,
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "postInstallGoogleCloudShellModal",
    onClose: onCancel,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "confirmGoogleCloudShellTitleText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallGoogleCloudShellModalTitle",
    defaultMessage: "Google Cloud Shell deployment",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_cloud_security_posture.GoogleCloudShellGuide, {
    commandText: installManagedCommands.googleCloudShell,
    hasProjectId: !!gcpProjectId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), error && isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: error,
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "confirmGoogleCloudShellModalCancelButton",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallGoogleCloudShellModal.cancelButton",
    defaultMessage: "Launch Google Cloud Shell later",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "confirmGoogleCloudShellModalConfirmButton",
    onClick: () => {
      window.open(cloudShellUrl);
      onConfirm();
    },
    fill: true,
    color: "primary",
    isLoading: isLoading,
    isDisabled: isError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallGoogleCloudShellModalConfirmButtonLabel",
    defaultMessage: "Launch Google Cloud Shell",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))));
};
exports.PostInstallGoogleCloudShellModal = PostInstallGoogleCloudShellModal;