"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFirstIntegrationSplashScreen = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../components");
var _components2 = require("../../../../../components");
var _services = require("../../../../../services");
var _layouts = require("../../../../../layouts");
var _hooks = require("../../../../../hooks");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/multi_page_layout/components/add_first_integration_splash.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CentralTitle = (0, _styledComponents.default)('h1')`
  text-align: center;
`;
const PaddedCentralTitle = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: 's',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(CentralTitle, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 7
  }
}, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: 'xl',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 5
  }
}));
const SubtitleText = (0, _styledComponents.default)(_eui.EuiText)`
  max-width: 250px;
  margin: 0 auto;
  text-align: center;
`;
// step numbers are not centered in smaller layouts without this
const CenteredEuiStepNumber = (0, _styledComponents.default)(_eui.EuiStepNumber)`
  margin: 0 auto;
`;

// step numbers are not centered in smaller layouts without this
const CenteredEuiImage = props => /*#__PURE__*/_react.default.createElement("div", {
  css: {
    margin: '0 auto'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, (0, _extends2.default)({
  role: "presentation"
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 5
  }
})));
const ResponsiveStepGroup = ({
  children
}) => {
  const isScreenSmall = (0, _eui.useIsWithinMaxBreakpoint)('s');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: isScreenSmall ? 'xs' : 'l',
    alignItems: "center",
    justifyContent: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, children);
};
const AddIntegrationStepsIllustrations = () => {
  const {
    http
  } = (0, _hooks.useStartServices)();
  const assetsBasePath = http.basePath.prepend('/plugins/fleet/assets/');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceEvenly",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ResponsiveStepGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiStepNumber, {
    status: "incomplete",
    number: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      margin: '0 auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "",
    src: assetsBasePath + '1_install_agent.svg',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.installAgentStepTitle",
    defaultMessage: "Install Elastic Agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(SubtitleText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.installAgentStep",
    defaultMessage: "Install agents on the hosts that you want to connect to Elastic.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['s', 'xs'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['s', 'xs'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "",
    src: assetsBasePath + 'arrow_right_curve_over.svg',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ResponsiveStepGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiStepNumber, {
    status: "incomplete",
    number: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "",
    src: assetsBasePath + '2_add_integration.svg',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.addIntegrationStepTitle",
    defaultMessage: "Add the integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(SubtitleText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.addIntegrationStep",
    defaultMessage: "Make a few selections to finalize how Elastic receives your data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['s', 'xs'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['s', 'xs'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "",
    src: assetsBasePath + 'arrow_right_curve_under.svg',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ResponsiveStepGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiStepNumber, {
    status: "incomplete",
    number: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "",
    src: assetsBasePath + '3_confirm_data.svg',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.confirmDataStepTitle",
    defaultMessage: "Confirm incoming data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(SubtitleText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.confirmDataStep",
    defaultMessage: "Explore and analyze the incoming data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }))))));
};
const NotObscuredByBottomBar = (0, _styledComponents.default)('div')`
  padding-bottom: 100px;
`;
const CenteredLearnMoreLink = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.elasticAgent,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.learnMoreLink",
    defaultMessage: "Learn more about installing Elastic Agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }))));
};
const AddFirstIntegrationSplashScreen = ({
  integrationInfo,
  packageInfo,
  isLoading,
  error,
  cancelUrl,
  cancelClickHandler,
  onNext
}) => {
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_components2.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.addFirstIntegrationSplash.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 11
        }
      }),
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 7
      }
    });
  }
  const topContent = /*#__PURE__*/_react.default.createElement(PaddedCentralTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.pageTitle",
    defaultMessage: "Ready to add your first integration?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    topContent: topContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(AddIntegrationStepsIllustrations, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(NotObscuredByBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredLearnMoreLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_.CreatePackagePolicyBottomBar, {
    cancelUrl: cancelUrl,
    cancelMessage: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "skipAgentInstallation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicyBottomBar.skipAddAgentButton",
      defaultMessage: "Add integration only (skip agent installation)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 15
      }
    })),
    cancelClickHandler: cancelClickHandler,
    isLoading: isLoading,
    onNext: onNext,
    noAnimation: true,
    actionMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addFirstIntegrationSplash.installAgentButton",
      defaultMessage: "Install Elastic Agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }), packageInfo && /*#__PURE__*/_react.default.createElement(_components.IntegrationBreadcrumb, {
    pkgTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
    pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo),
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 11
    }
  })));
};
exports.AddFirstIntegrationSplashScreen = AddFirstIntegrationSplashScreen;