"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDefinitionField = ReportDefinitionField;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _public = require("@kbn/observability-shared-plugin/public");
var _url_constants = require("../../configurations/constants/url_constants");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _utils = require("../../configurations/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/report_definition_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ReportDefinitionField({
  singleSelection,
  keepHistory,
  series,
  field: fieldProp,
  seriesConfig,
  onChange,
  filters
}) {
  var _labels$field;
  const {
    dataView
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const field = typeof fieldProp === 'string' ? fieldProp : fieldProp.field;
  const {
    reportDefinitions: selectedReportDefinitions = {}
  } = series;
  const {
    labels,
    baseFilters,
    definitionFields
  } = seriesConfig;
  const queryFilters = (0, _react.useMemo)(() => {
    const filtersN = [];
    (baseFilters !== null && baseFilters !== void 0 ? baseFilters : []).concat(filters !== null && filters !== void 0 ? filters : []).forEach(qFilter => {
      if (qFilter.query) {
        filtersN.push(qFilter.query);
      }
      const existFilter = qFilter;
      if (existFilter.query.exists) {
        filtersN.push({
          exists: existFilter.query.exists
        });
      }
    });
    if (!(0, _lodash.isEmpty)(selectedReportDefinitions)) {
      definitionFields.forEach(fieldObj => {
        const fieldT = typeof fieldObj === 'string' ? fieldObj : fieldObj.field;
        if (dataView && selectedReportDefinitions !== null && selectedReportDefinitions !== void 0 && selectedReportDefinitions[fieldT] && fieldT !== field) {
          const values = selectedReportDefinitions === null || selectedReportDefinitions === void 0 ? void 0 : selectedReportDefinitions[fieldT];
          if (!values.includes(_url_constants.ALL_VALUES_SELECTED)) {
            const valueFilter = (0, _utils.buildPhrasesFilter)(fieldT, values, dataView)[0];
            if (valueFilter.query) {
              filtersN.push(valueFilter.query);
            }
          }
        }
      });
    }
    return filtersN;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(selectedReportDefinitions), JSON.stringify(baseFilters)]);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.FieldValueSuggestions, {
    label: (_labels$field = labels[field]) !== null && _labels$field !== void 0 ? _labels$field : field,
    sourceField: field,
    dataViewTitle: dataView.title,
    selectedValue: selectedReportDefinitions === null || selectedReportDefinitions === void 0 ? void 0 : selectedReportDefinitions[field],
    onChange: val => onChange(field, val),
    filters: queryFilters,
    time: series.time,
    fullWidth: true,
    asCombobox: true,
    allowExclusions: false,
    allowAllValuesSelection: true,
    usePrependLabel: false,
    compressed: false,
    required: (0, _lodash.isEmpty)(selectedReportDefinitions),
    singleSelection: singleSelection,
    keepHistory: keepHistory,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  });
}