"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploratoryView = ExploratoryView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _use_kibana = require("./hooks/use_kibana");
var _use_series_storage = require("./hooks/use_series_storage");
var _use_lens_attributes = require("./hooks/use_lens_attributes");
var _use_app_data_view = require("./hooks/use_app_data_view");
var _series_views = require("./views/series_views");
var _lens_embeddable = require("./lens_embeddable");
var _empty_view = require("./components/empty_view");
var _use_time_range = require("./hooks/use_time_range");
var _action_menu = require("./components/action_menu");
var _exploratory_view_config = require("./contexts/exploratory_view_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/exploratory_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ExploratoryView({
  saveAttributes
}) {
  const {
    services: {
      lens
    }
  } = (0, _use_kibana.useKibana)();
  const seriesBuilderRef = (0, _react.useRef)(null);
  const wrapperRef = (0, _react.useRef)(null);
  const [height, setHeight] = (0, _react.useState)('100vh');
  const {
    isEditMode
  } = (0, _exploratory_view_config.useExploratoryView)();
  const [lensAttributes, setLensAttributes] = (0, _react.useState)(null);
  const {
    loadDataView,
    loading
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const {
    firstSeries,
    allSeries,
    lastRefresh,
    reportType,
    setChartTimeRangeContext
  } = (0, _use_series_storage.useSeriesStorage)();
  const lensAttributesT = (0, _use_lens_attributes.useLensAttributes)();
  const timeRange = (0, _use_time_range.useExpViewTimeRange)();
  const setHeightOffset = () => {
    if (seriesBuilderRef !== null && seriesBuilderRef !== void 0 && seriesBuilderRef.current && wrapperRef.current) {
      const headerOffset = wrapperRef.current.getBoundingClientRect().top;
      setHeight(`calc(100vh - ${headerOffset + 40}px)`);
    }
  };
  (0, _react.useEffect)(() => {
    allSeries.forEach(seriesT => {
      loadDataView({
        dataType: seriesT.dataType
      });
    });
  }, [allSeries, loadDataView]);
  (0, _react.useEffect)(() => {
    setLensAttributes(lensAttributesT);
    if (saveAttributes) {
      saveAttributes(lensAttributesT);
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(lensAttributesT !== null && lensAttributesT !== void 0 ? lensAttributesT : {}), lastRefresh]);
  (0, _react.useEffect)(() => {
    setHeightOffset();
  });
  const collapseFn = (0, _react.useRef)();
  const [hiddenPanel, setHiddenPanel] = (0, _react.useState)('');
  const onCollapse = panelId => {
    setHiddenPanel(prevState => panelId === prevState ? '' : panelId);
  };
  const onChange = panelId => {
    onCollapse(panelId);
    if (collapseFn.current) {
      collapseFn.current(panelId, panelId === 'seriesPanel' ? 'right' : 'left');
    }
  };
  return lens ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_action_menu.ExpViewActionMenu, {
    timeRange: timeRange,
    lensAttributes: lensAttributes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(LensWrapper, {
    ref: wrapperRef,
    height: height,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ResizableContainer, {
    direction: "vertical",
    onToggleCollapsed: onCollapse,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, (EuiResizablePanel, _EuiResizableButton, {
    togglePanel
  }) => {
    collapseFn.current = (id, direction) => togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel(id, {
      direction
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": "o11yExploratoryViewButton",
      size: "xs"
    }, hiddenPanel === 'chartPanel' ? {
      iconType: 'arrowRight'
    } : {
      iconType: 'arrowDown'
    }, {
      onClick: () => onChange('chartPanel'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 21
      }
    }), hiddenPanel === 'chartPanel' ? SHOW_CHART_LABEL : HIDE_CHART_LABEL))), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: isEditMode ? 40 : 60,
      minSize: '30%',
      mode: 'collapsible',
      id: "chartPanel",
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    }, lensAttributes ? /*#__PURE__*/_react.default.createElement(_lens_embeddable.LensEmbeddable, {
      setChartTimeRangeContext: setChartTimeRangeContext,
      lensAttributes: lensAttributes,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_empty_view.EmptyView, {
      series: firstSeries,
      loading: loading,
      reportType: reportType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: isEditMode ? 60 : 40,
      minSize: "10%",
      mode: 'main',
      id: "seriesPanel",
      color: "subdued",
      className: "paddingTopSmall",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_series_views.SeriesViews, {
      seriesBuilderRef: seriesBuilderRef,
      onSeriesPanelCollapse: onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 19
      }
    })));
  }), hiddenPanel === 'seriesPanel' && /*#__PURE__*/_react.default.createElement(ShowPreview, {
    onClick: () => onChange('seriesPanel'),
    iconType: "arrowUp",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, PREVIEW_LABEL))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, LENS_NOT_AVAILABLE));
}
const LensWrapper = _styled.default.div`
  min-height: 400px;
  height: ${props => props.height};

  &&& > div {
    height: 100%;
  }
`;
const ResizableContainer = (0, _styled.default)(_eui.EuiResizableContainer)`
  height: 100%;
  &&& .paddingTopSmall {
    padding-top: 8px;
  }
  #chartPanel {
    > .euiPanel {
      padding-bottom: 0;
      padding-top: 0;
    }
    .expExpressionRenderer__expression {
      padding-bottom: 0 !important;
      padding-top: 0 !important;
    }
  }
`;
const ShowPreview = (0, _styled.default)(_eui.EuiButtonEmpty)`
  position: absolute;
  bottom: 34px;
`;
const PREVIEW_LABEL = _i18n.i18n.translate('xpack.exploratoryView.preview', {
  defaultMessage: 'Preview'
});
const HIDE_CHART_LABEL = _i18n.i18n.translate('xpack.exploratoryView.hideChart', {
  defaultMessage: 'Hide chart'
});
const SHOW_CHART_LABEL = _i18n.i18n.translate('xpack.exploratoryView.showChart', {
  defaultMessage: 'Show chart'
});
const LENS_NOT_AVAILABLE = _i18n.i18n.translate('xpack.exploratoryView.lensDisabled', {
  defaultMessage: 'Lens app is not available, please enable Lens to use exploratory view.'
});