"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostAttackDiscoveryBulkResponse = exports.PostAttackDiscoveryBulkRequestBody = void 0;
var _zod = require("@kbn/zod");
var _attack_discovery_api_alert = require("../../../attack_discovery_api_alert.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Attack discovery bulk API endpoint
 *   version: 2023-10-31
 */

const PostAttackDiscoveryBulkRequestBody = exports.PostAttackDiscoveryBulkRequestBody = _zod.z.object({
  /**
   * Configuration object containing all parameters for the bulk update operation
   */
  update: _zod.z.object({
    /**
     * Array of Attack discovery IDs to update
     */
    ids: _zod.z.array(_zod.z.string()),
    /**
     * When provided, update the kibana.alert.workflow_status of the attack discovery alerts
     */
    kibana_alert_workflow_status: _zod.z.enum(['open', 'acknowledged', 'closed']).optional(),
    /**
     * When provided, update the visibility of the alert, as determined by the kibana.alert.attack_discovery.users field
     */
    visibility: _zod.z.enum(['not_shared', 'shared']).optional(),
    /**
     * When true, returns the updated Attack discoveries with text replacements applied to the detailsMarkdown, entitySummaryMarkdown, summaryMarkdown, and title fields. This substitutes anonymized values with human-readable equivalents. Defaults to `true`.
     */
    with_replacements: _zod.z.boolean().optional().default(true),
    /**
     * Enables a markdown syntax used to render pivot fields, for example `{{ user.name james }}`. When disabled, the same example would be rendered as `james`. This is primarily used for Attack discovery views within Kibana. Defaults to `false`.
     */
    enable_field_rendering: _zod.z.boolean().optional().default(false)
  })
});
const PostAttackDiscoveryBulkResponse = exports.PostAttackDiscoveryBulkResponse = _zod.z.object({
  /**
   * Array of updated Attack discovery alert objects. Each item includes the applied modifications from the bulk update request.
   */
  data: _zod.z.array(_attack_discovery_api_alert.AttackDiscoveryApiAlert)
});