"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCellRendererAccessor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/security/accessors/get_cell_renderer_accessor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createCellRendererAccessor = async cellRendererFeature => {
  if (!cellRendererFeature) return undefined;
  const cellRendererGetter = await cellRendererFeature.getRenderer();
  function getCellRenderer(fieldName) {
    const CellRenderer = cellRendererGetter(fieldName);
    if (!CellRenderer) return undefined;
    return /*#__PURE__*/_react.default.memo(function SecuritySolutionCellRenderer(props) {
      return /*#__PURE__*/_react.default.createElement(CellRenderer, (0, _extends2.default)({}, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 14
        }
      }));
    });
  }
  return getCellRenderer;
};
exports.createCellRendererAccessor = createCellRendererAccessor;