"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Summary;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../common/translations");
var _use_overview_summary_panel = require("../../../../hooks/use_overview_summary_panel");
var _panel = require("./panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/summary/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Summary() {
  const {
    isSummaryPanelLoading,
    totalDocsCount,
    sizeInBytes,
    isUserAllowedToSeeSizeInBytes,
    totalServicesCount,
    totalHostsCount
  } = (0, _use_overview_summary_panel.useOverviewSummaryPanel)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleDocuments,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDocumentsIndicatorTotalCount,
    value: totalDocsCount,
    isLoading: isSummaryPanelLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDocumentsIndicatorSize,
    value: sizeInBytes,
    isLoading: isSummaryPanelLoading,
    userHasPrivilege: isUserAllowedToSeeSizeInBytes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleResources,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelResourcesIndicatorServices,
    value: totalServicesCount,
    isLoading: isSummaryPanelLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelResourcesIndicatorSize,
    value: totalHostsCount,
    isLoading: isSummaryPanelLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}
module.exports = exports.default;