"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiSettingsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _ui_settings_api = require("./ui_settings_api");
var _ui_settings_client = require("./ui_settings_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @Internal
 * @Deprecated
 **/
class UiSettingsService {
  constructor() {
    (0, _defineProperty2.default)(this, "uiSettingsApi", void 0);
    (0, _defineProperty2.default)(this, "uiSettingsClient", void 0);
    (0, _defineProperty2.default)(this, "done$", new _rxjs.Subject());
  }
  setup({
    http,
    injectedMetadata
  }) {
    this.uiSettingsApi = new _ui_settings_api.UiSettingsApi(http);
    http.addLoadingCountSource(this.uiSettingsApi.getLoadingCount$());

    // TODO: Migrate away from legacyMetadata https://github.com/elastic/kibana/issues/22779
    const legacyMetadata = injectedMetadata.getLegacyMetadata();
    this.uiSettingsClient = new _ui_settings_client.UiSettingsClient({
      api: this.uiSettingsApi,
      defaults: legacyMetadata.uiSettings.defaults,
      initialSettings: legacyMetadata.uiSettings.user,
      done$: this.done$
    });
    return this.uiSettingsClient;
  }
  start() {
    return this.uiSettingsClient;
  }
  stop() {
    this.done$.complete();
    if (this.uiSettingsApi) {
      this.uiSettingsApi.stop();
    }
  }
}
exports.UiSettingsService = UiSettingsService;