"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Scope = exports.PluginModule = exports.Global = exports.Fork = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _inversify = require("inversify");
var _coreDi = require("@kbn/core-di");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Current context to resolve the global services.
 *
 * Some short-lived services, such as the current request, cannot be bound in the global scope, and hence, they are placed in a child container.
 * The `Context` service holds a reference to the child container and is used to resolve global services within the current context, making short-lived services available.
 */
const Context = Symbol('Context');

/**
 * The service identifier for the global service references.
 */
const Global = exports.Global = Symbol.for('Global');

/**
 * Current plugin scope identifier.
 *
 * This service is used to determine the current plugin scope identifier when resolving global services.
 * When the request originates from the forked context, it will be used to resolve the requested global service within the corresponding plugin scope of the forked context.
 */
const Id = Symbol('Id');

/**
 * Reference to the parent container.
 *
 * This is a workaround as there is no built-in way to resolve the parent container.
 */
const Parent = Symbol('Parent');

/**
 * Plugin scope factory.
 *
 * The factory creates a new container for the plugin dependencies.
 * Services registered in this scope are not visible outside unless they are explicitely exposed using the `Global` symbol.
 */
const Scope = exports.Scope = Symbol.for('Scope');

/**
 * Isolated child context factory.
 *
 * This factory creates an intermediate or temporary child container to handle HTTP requests or other short-lived operations.
 */
const Fork = exports.Fork = Symbol.for('Fork');
class PluginModule extends _inversify.ContainerModule {
  constructor(root, options) {
    super(({
      bind,
      onActivation
    }) => {
      bind(_inversify.Container).toConstantValue(root);
      bind(Fork).toDynamicValue(this.getForkFactory.bind(this)).inRequestScope();
      bind(_coreDi.OnSetup).toConstantValue(this.registerGlobals.bind(this));
      bind(Scope).toDynamicValue(this.getScopeFactory.bind(this)).inRequestScope();
      bind(_coreDi.Setup).toResolvedValue(this.getDefaultContract.bind(this)).inRequestScope();
      bind(_coreDi.Start).toResolvedValue(this.getDefaultContract.bind(this)).inRequestScope();
      onActivation(Global, this.onGlobalActivation.bind(this));
      onActivation(_coreDi.Setup, this.onContractActivation.bind(this, _coreDi.OnSetup));
      onActivation(_coreDi.Start, this.onContractActivation.bind(this, _coreDi.OnStart));
    });
    (0, _defineProperty2.default)(this, "services", new WeakMap());
    (0, _defineProperty2.default)(this, "activated", {
      [_coreDi.OnSetup]: new WeakSet(),
      [_coreDi.OnStart]: new WeakSet()
    });
    (0, _defineProperty2.default)(this, "bound", new WeakSet());
    this.options = options;
  }
  getDefaultContract() {
    return undefined;
  }
  onContractActivation(hook, {
    get
  }, contract) {
    const container = get(_inversify.Container);
    if (this.activated[hook].has(container)) {
      return contract;
    }
    container.getAll(hook, {
      chained: true
    }).forEach(callback => callback(container));
    this.activated[hook].add(container);
    return contract;
  }
  onGlobalActivation({
    get
  }, service) {
    const scope = get(_inversify.Container);
    const parent = get(Parent, {
      optional: true
    });
    const context = get(Context);
    const id = get(Id);
    const index = this.getServicesCount(scope, service);
    this.incrementServicesCount(scope, service);
    if (parent !== context) {
      this.incrementServicesCount(context, service);
    }
    context.bind(service).toResolvedValue(
    // eslint-disable-next-line @typescript-eslint/no-shadow
    (origin, context = origin) => {
      const target = context.get(Scope)(id);
      this.registerGlobals(origin);
      this.inheritGlobals(target);
      return this.getServicesCount(scope, service) > 1 ? target.getAll(service)[index] : target.get(service);
    }, [_inversify.Container, {
      serviceIdentifier: Context,
      optional: true
    }]).inRequestScope();
    return service;
  }
  getForkFactory({
    get
  }) {
    const container = get(_inversify.Container);
    return id => {
      const fork = this.createChild(container);
      if (id) {
        fork.onDeactivation(id, (0, _lodash.once)(() => fork.unbindAll()));
      }
      return fork.get(Scope)(id);
    };
  }
  getScopeFactory({
    get
  }) {
    const context = get(_inversify.Container);
    return id => {
      if (!id) {
        return context;
      }
      if (!context.isCurrentBound(id)) {
        var _context$get$get, _context$get;
        const parent = (_context$get$get = (_context$get = context.get(Parent, {
          optional: true
        })) === null || _context$get === void 0 ? void 0 : _context$get.get(Scope)(id)) !== null && _context$get$get !== void 0 ? _context$get$get : context;
        const scope = this.createChild(parent);
        scope.bind(Id).toConstantValue(id);
        scope.bind(Context).toConstantValue(context).onDeactivation((0, _lodash.once)(() => context.unbind(id).catch(_lodash.noop)));
        scope.get(Context);
        context.bind(id).toConstantValue(scope).onDeactivation((0, _lodash.once)(() => scope.unbindAll()));
      }
      return context.get(id);
    };
  }
  registerGlobals(scope) {
    if (this.bound.has(scope)) {
      return;
    }
    this.bound.add(scope);
    if (!scope.isCurrentBound(Global)) {
      return;
    }
    scope.getAll(Global);
  }
  inheritGlobals(scope) {
    if (this.bound.has(scope)) {
      return;
    }
    this.bound.add(scope);
    for (const [service, count] of (_this$services$get = this.services.get(scope.get(Context))) !== null && _this$services$get !== void 0 ? _this$services$get : []) {
      var _this$services$get;
      for (let index = 0; index < count; index++) {
        scope.bind(service).toResolvedValue(context => count > 1 ? context.getAll(service)[index] : context.get(service), [Context]).inRequestScope();
      }
    }
  }
  createChild(parent) {
    const child = new _inversify.Container({
      ...this.options,
      parent
    });
    child.bind(_inversify.Container).toConstantValue(child);
    child.bind(Parent).toConstantValue(parent);
    return child;
  }
  getServicesCount(scope, service) {
    var _this$services$get$ge, _this$services$get2;
    return (_this$services$get$ge = (_this$services$get2 = this.services.get(scope)) === null || _this$services$get2 === void 0 ? void 0 : _this$services$get2.get(service)) !== null && _this$services$get$ge !== void 0 ? _this$services$get$ge : 0;
  }
  incrementServicesCount(scope, service) {
    var _this$services$get3;
    if (!this.services.has(scope)) {
      this.services.set(scope, new Map());
    }
    (_this$services$get3 = this.services.get(scope)) === null || _this$services$get3 === void 0 ? void 0 : _this$services$get3.set(service, this.getServicesCount(scope, service) + 1);
  }
}
exports.PluginModule = PluginModule;