"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _get = require("./get");
var _resolve_deprecated_api = require("./resolve_deprecated_api");
var _post_validation_handler = require("./post_validation_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerRoutes({
  http,
  coreUsageData,
  logger
}) {
  const router = http.createRouter('/api/deprecations');
  (0, _get.registerGetRoute)(router);
  (0, _post_validation_handler.registerApiDeprecationsPostValidationHandler)({
    http,
    coreUsageData,
    logger
  });
  (0, _resolve_deprecated_api.registerMarkAsResolvedRoute)(router, {
    coreUsageData
  });
}