"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Navigation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _nested_secondary_menu = require("./nested_secondary_menu");
var _secondary_menu = require("./secondary_menu");
var _side_nav = require("./side_nav");
var _get_has_submenu = require("../utils/get_has_submenu");
var _use_layout_width = require("../hooks/use_layout_width");
var _use_navigation = require("../hooks/use_navigation");
var _use_responsive_menu = require("../hooks/use_responsive_menu");
var _focus_main_content = require("../utils/focus_main_content");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Navigation = ({
  activeItemId,
  isCollapsed: isCollapsedProp,
  items,
  logo,
  onItemClick,
  setWidth,
  sidePanelFooter,
  ...rest
}) => {
  var _rest$dataTestSubj, _openerNode$sections;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isCollapsed = isMobile || isCollapsedProp;
  const {
    actualActiveItemId,
    visuallyActivePageId,
    visuallyActiveSubpageId,
    isSidePanelOpen,
    openerNode
  } = (0, _use_navigation.useNavigation)(isCollapsed, items, logo.id, activeItemId);
  const {
    overflowMenuItems,
    primaryMenuRef,
    visibleMenuItems
  } = (0, _use_responsive_menu.useResponsiveMenu)(isCollapsed, items.primaryItems);
  (0, _use_layout_width.useLayoutWidth)({
    isCollapsed,
    isSidePanelOpen,
    setWidth
  });
  const wrapperStyles = (0, _react2.css)`
    display: flex;
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    id: "navigation-root",
    css: wrapperStyles,
    "data-test-subj": (_rest$dataTestSubj = rest['data-test-subj']) !== null && _rest$dataTestSubj !== void 0 ? _rest$dataTestSubj : 'navigation-root',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav, {
    isCollapsed: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Logo, (0, _extends2.default)({
    isHighlighted: visuallyActivePageId === logo.id,
    isCurrent: actualActiveItemId === logo.id,
    isCollapsed: isCollapsed,
    onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(logo)
  }, logo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenu, {
    ref: primaryMenuRef,
    isCollapsed: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, visibleMenuItems.map(item => {
    const {
      sections,
      ...itemProps
    } = item;
    return /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Popover, {
      key: item.id,
      hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
      isSidePanelOpen: !isCollapsed && item.id === (openerNode === null || openerNode === void 0 ? void 0 : openerNode.id),
      label: item.label,
      trigger: /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenuItem, (0, _extends2.default)({
        isCollapsed: isCollapsed,
        isHighlighted: item.id === visuallyActivePageId,
        isCurrent: actualActiveItemId === item.id,
        hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
        onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(item)
      }, itemProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 19
        }
      }), item.label),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 15
      }
    }, closePopover => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu, {
      title: item.label,
      badgeType: item.badgeType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 19
      }
    }, sections === null || sections === void 0 ? void 0 : sections.map(section => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu.Section, {
      key: section.id,
      label: section.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 23
      }
    }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu.Item, (0, _extends2.default)({
      key: subItem.id,
      isHighlighted: subItem.id === visuallyActiveSubpageId,
      isCurrent: actualActiveItemId === subItem.id,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem);
        if (subItem.href) {
          closePopover();
        }
      },
      testSubjPrefix: "popoverItem"
    }, subItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 27
      }
    }), subItem.label))))));
  }), overflowMenuItems.length > 0 && /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Popover, {
    hasContent: true,
    isSidePanelOpen: false,
    label: _i18n.i18n.translate('core.ui.chrome.sideNavigation.moreMenuLabel', {
      defaultMessage: 'More'
    }),
    persistent: true,
    trigger: /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenuItem, {
      as: "button",
      "data-test-subj": "sideNavMoreMenuItem",
      isHighlighted: overflowMenuItems.some(item => item.id === visuallyActivePageId),
      isCollapsed: isCollapsed,
      iconType: "boxesVertical",
      hasContent: true,
      href: "",
      id: "more-menu",
      label: _i18n.i18n.translate('core.ui.chrome.sideNavigation.moreMenuItemLabel', {
        defaultMessage: 'More'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.chrome.sideNavigation.moreMenuItemText",
      defaultMessage: "More",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, closePopover => /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.Panel, {
    id: "main",
    title: _i18n.i18n.translate('core.ui.chrome.sideNavigation.nestedSecondaryMenuMoreTitle', {
      defaultMessage: 'More'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 21
    }
  }, overflowMenuItems.map(item => {
    const hasSubmenu = (0, _get_has_submenu.getHasSubmenu)(item);
    const {
      sections,
      ...itemProps
    } = item;
    return /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.PrimaryMenuItem, (0, _extends2.default)({
      key: item.id,
      isHighlighted: item.id === visuallyActivePageId,
      isCollapsed: isCollapsed,
      hasSubmenu: hasSubmenu,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(item);
        if (!hasSubmenu) {
          closePopover();
          (0, _focus_main_content.focusMainContent)();
        }
      }
    }, itemProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 27
      }
    }), item.label);
  }))), overflowMenuItems.filter(_get_has_submenu.getHasSubmenu).map(item => {
    var _item$sections;
    return /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.Panel, {
      key: `submenu-${item.id}`,
      id: item.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.Header, {
      title: item.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 23
      }
    }), (_item$sections = item.sections) === null || _item$sections === void 0 ? void 0 : _item$sections.map(section => /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.Section, {
      key: section.id,
      label: section.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 25
      }
    }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_nested_secondary_menu.NestedSecondaryMenu.Item, (0, _extends2.default)({
      key: subItem.id,
      isHighlighted: subItem.id === visuallyActiveSubpageId,
      isCurrent: actualActiveItemId === subItem.id,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem);
        closePopover();
        (0, _focus_main_content.focusMainContent)();
      }
    }, subItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 29
      }
    }), subItem.label)))));
  })))), /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Footer, {
    isCollapsed: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, items.footerItems.slice(0, _constants.MAX_FOOTER_ITEMS).map(item => {
    const {
      sections,
      ...itemProps
    } = item;
    return /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Popover, {
      key: item.id,
      hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
      isSidePanelOpen: !isCollapsed && item.id === (openerNode === null || openerNode === void 0 ? void 0 : openerNode.id),
      label: item.label,
      persistent: false,
      trigger: /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.FooterItem, (0, _extends2.default)({
        isHighlighted: item.id === visuallyActivePageId,
        isCurrent: actualActiveItemId === item.id,
        hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
        onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(item)
      }, itemProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 19
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 15
      }
    }, closePopover => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu, {
      title: item.label,
      badgeType: item.badgeType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 19
      }
    }, sections === null || sections === void 0 ? void 0 : sections.map(section => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu.Section, {
      key: section.id,
      label: section.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 23
      }
    }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu.Item, (0, _extends2.default)({
      key: subItem.id,
      isHighlighted: subItem.id === visuallyActiveSubpageId,
      isCurrent: actualActiveItemId === subItem.id,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem);
        if (subItem.href) {
          closePopover();
        }
      }
    }, subItem, {
      testSubjPrefix: "popoverFooterItem",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 27
      }
    }), subItem.label))))));
  }))), isSidePanelOpen && openerNode && /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Panel, {
    footer: sidePanelFooter,
    openerNode: openerNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu, {
    badgeType: openerNode.badgeType,
    isPanel: true,
    title: openerNode.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  }, (_openerNode$sections = openerNode.sections) === null || _openerNode$sections === void 0 ? void 0 : _openerNode$sections.map(section => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu.Section, {
    key: section.id,
    label: section.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 15
    }
  }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu.Item, (0, _extends2.default)({
    key: subItem.id,
    isHighlighted: subItem.id === visuallyActiveSubpageId,
    isCurrent: actualActiveItemId === subItem.id,
    onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem),
    testSubjPrefix: "sidePanelItem"
  }, subItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 19
    }
  }), subItem.label)))))));
};
exports.Navigation = Navigation;