"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelStateManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Manages the last active item state for navigation panel openers.
 * Provides persistence across browser sessions using sessionStorage.
 */
class PanelStateManager {
  constructor(basePath = '/') {
    (0, _defineProperty2.default)(this, "key", void 0);
    (0, _defineProperty2.default)(this, "state", {});
    this.basePath = basePath;
    const STORAGE_KEY = 'core.chrome.sidenav_v2.panel_state';
    this.key = `${STORAGE_KEY}:${this.basePath}`;
    this.load();
  }
  getPanelLastActive(panelId) {
    return this.state[panelId];
  }
  setPanelLastActive(panelId, itemId) {
    this.state[panelId] = itemId;
    this.save();
  }
  clear() {
    this.state = {};
    try {
      window.sessionStorage.removeItem(this.key);
    } catch {
      // Ignore storage errors
    }
  }
  load() {
    try {
      const stored = window.sessionStorage.getItem(this.key);
      this.state = stored ? JSON.parse(stored) : {};
    } catch {
      // Ignore parsing errors, start with empty cache
      this.state = {};
    }
  }
  save() {
    try {
      window.sessionStorage.setItem(this.key, JSON.stringify(this.state));
    } catch {
      // Ignore storage errors
    }
  }
}
exports.PanelStateManager = PanelStateManager;