"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderPageAnnouncer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_page_announcer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_BRAND = 'Elastic'; // This may need to be DRYed out with https://github.com/elastic/kibana/blob/main/src/core/packages/rendering/server-internal/src/views/template.tsx#L35
const SEPARATOR = ' - ';
const HeaderPageAnnouncer = ({
  breadcrumbs$,
  customBranding$
}) => {
  var _useObservable;
  const [routeTitle, setRouteTitle] = (0, _react.useState)('');
  const branding = ((_useObservable = (0, _useObservable2.default)(customBranding$)) === null || _useObservable === void 0 ? void 0 : _useObservable.pageTitle) || DEFAULT_BRAND;
  const breadcrumbs = (0, _useObservable2.default)(breadcrumbs$, []);
  const skipLinkRef = (0, _react.useRef)(null);
  const [shouldHandleTab, setShouldHandleTab] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!breadcrumbs.length) {
      setRouteTitle('');
      return;
    }
    const breadcrumbText = [...breadcrumbs].reverse().map(breadcrumb => {
      if (typeof breadcrumb['aria-label'] === 'string') {
        return breadcrumb['aria-label'];
      }
      if (typeof breadcrumb.text === 'string') {
        return breadcrumb.text;
      }
      return null;
    }).filter(Boolean);
    breadcrumbText.push(branding);
    const joinedBreadcrumbs = breadcrumbText.join(SEPARATOR);
    if (routeTitle !== joinedBreadcrumbs) {
      setRouteTitle(joinedBreadcrumbs);
      setShouldHandleTab(true);
    }
  }, [breadcrumbs, branding, routeTitle]);
  (0, _react.useEffect)(() => {
    const events = ['keydown', 'mousedown'];
    const handleTabFn = e => {
      if (shouldHandleTab && e instanceof KeyboardEvent && e.key === _eui.keys.TAB) {
        var _skipLinkRef$current, _e$preventDefault;
        (_skipLinkRef$current = skipLinkRef.current) === null || _skipLinkRef$current === void 0 ? void 0 : _skipLinkRef$current.focus();
        (_e$preventDefault = e.preventDefault) === null || _e$preventDefault === void 0 ? void 0 : _e$preventDefault.call(e);
      }
      setShouldHandleTab(false);
    };
    const removeListeners = () => events.forEach(event => window.removeEventListener(event, handleTabFn));
    if (shouldHandleTab) {
      events.forEach(event => window.addEventListener(event, handleTabFn, {
        once: true
      }));
    } else {
      removeListeners();
    }
    return removeListeners;
  }, [shouldHandleTab]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLiveAnnouncer, {
    clearAfterMs: false,
    "aria-label": _i18n.i18n.translate('core.ui.pageChangeAnnouncements', {
      defaultMessage: 'Page change announcements'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, routeTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSkipLink, {
    buttonRef: skipLinkRef,
    position: "fixed",
    destinationId: "",
    fallbackDestination: _coreChromeLayoutConstants.MAIN_CONTENT_SELECTORS,
    overrideLinkBehavior: true,
    "data-test-subj": "skipToMainButton",
    role: "button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('core.ui.skipToMainButton', {
    defaultMessage: 'Skip to main content'
  })));
};
exports.HeaderPageAnnouncer = HeaderPageAnnouncer;