"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRanges = ColorRanges;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _palettes = require("../../../palettes");
var _color_ranges_extra_actions = require("./color_ranges_extra_actions");
var _color_ranges_item = require("./color_ranges_item");
var _color_ranges_validation = require("./color_ranges_validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/coloring/color_ranges/color_ranges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ColorRanges({
  colorRanges,
  paletteConfiguration,
  showExtraActions,
  dispatch
}) {
  var _paletteConfiguration, _paletteConfiguration2;
  const [colorRangesValidity, setColorRangesValidity] = (0, _react.useState)({});
  const lastColorRange = colorRanges[colorRanges.length - 1];
  const errors = (0, _color_ranges_validation.getErrorMessages)(colorRangesValidity);
  const continuity = (_paletteConfiguration = paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.continuity) !== null && _paletteConfiguration !== void 0 ? _paletteConfiguration : _palettes.DEFAULT_CONTINUITY;
  const rangeType = (_paletteConfiguration2 = paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.rangeType) !== null && _paletteConfiguration2 !== void 0 ? _paletteConfiguration2 : _palettes.DEFAULT_RANGE_TYPE;
  (0, _react.useEffect)(() => {
    setColorRangesValidity((0, _color_ranges_validation.validateColorRanges)(colorRanges, rangeType === 'percent'));
  }, [colorRanges, rangeType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `lnsPalettePanel_dynamicColoring_custom_color_ranges`,
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, colorRanges.map((colorRange, index) => {
    var _ref, _colorRange$end;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `${(_ref = (_colorRange$end = colorRange.end) !== null && _colorRange$end !== void 0 ? _colorRange$end : 0 + colorRange.start) !== null && _ref !== void 0 ? _ref : 0}${index}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_color_ranges_item.ColorRangeItem, {
      colorRange: colorRange,
      dispatch: dispatch,
      colorRanges: colorRanges,
      continuity: continuity,
      rangeType: rangeType,
      index: index,
      validation: colorRangesValidity[index],
      accessor: "start",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }));
  }), lastColorRange ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_color_ranges_item.ColorRangeItem, {
    colorRange: lastColorRange,
    dispatch: dispatch,
    colorRanges: colorRanges,
    continuity: continuity,
    rangeType: rangeType,
    index: colorRanges.length - 1,
    validation: colorRangesValidity.last,
    accessor: "end",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, errors.map(error => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    key: `${(0, _lodash.camelCase)(error)}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, error))), showExtraActions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_color_ranges_extra_actions.ColorRangesExtraActions, {
    dispatch: dispatch,
    shouldDisableAdd: Boolean((paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.maxSteps) && colorRanges.length >= (paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.maxSteps) || errors.length),
    shouldDisableDistribute: Boolean(colorRanges.length === 1),
    shouldDisableReverse: Boolean(colorRanges.length === 1),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  })) : null);
}