"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDecodeSOAttributes = void 0;
var _runtime_types = require("../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDecodeSOAttributes = (savedObjects, type) => {
  const decodeRes = new Map();
  for (const so of savedObjects) {
    decodeRes.set(so.id, (0, _runtime_types.decodeOrThrow)(type)(so.attributes));
  }
  return decodeRes;
};
exports.bulkDecodeSOAttributes = bulkDecodeSOAttributes;