"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CAI_ATTACHMENTS_SYNC_TYPE = exports.CAI_ATTACHMENTS_SOURCE_INDEX = exports.CAI_ATTACHMENTS_INDEX_VERSION = void 0;
exports.getAttachmentsDestinationIndexAlias = getAttachmentsDestinationIndexAlias;
exports.getAttachmentsDestinationIndexName = getAttachmentsDestinationIndexName;
exports.getCAIAttachmentsBackfillTaskId = exports.getAttachmentsSynchronizationSourceQuery = exports.getAttachmentsSourceQuery = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_ATTACHMENTS_INDEX_NAME_BASE = '.internal.cases-attachments';
function getAttachmentsDestinationIndexName(spaceId, owner) {
  return `${CAI_ATTACHMENTS_INDEX_NAME_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_ATTACHMENTS_INDEX_ALIAS_BASE = '.cases-attachments';
function getAttachmentsDestinationIndexAlias(spaceId, owner) {
  return `${CAI_ATTACHMENTS_INDEX_ALIAS_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_ATTACHMENTS_INDEX_VERSION = exports.CAI_ATTACHMENTS_INDEX_VERSION = 1;
const CAI_ATTACHMENTS_SYNC_TYPE = exports.CAI_ATTACHMENTS_SYNC_TYPE = 'cai_attachments_sync';
const getAttachmentsSourceQuery = (spaceId, owner) => ({
  bool: {
    filter: [{
      term: {
        type: 'cases-comments'
      }
    }, {
      term: {
        namespaces: spaceId
      }
    }, {
      term: {
        'cases-comments.owner': owner
      }
    }],
    must: [{
      bool: {
        should: [{
          term: {
            'cases-comments.type': 'externalReference'
          }
        }, {
          term: {
            'cases-comments.type': 'alert'
          }
        }],
        minimum_should_match: 1
      }
    }]
  }
});
exports.getAttachmentsSourceQuery = getAttachmentsSourceQuery;
const CAI_ATTACHMENTS_SOURCE_INDEX = exports.CAI_ATTACHMENTS_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_ATTACHMENTS_BACKFILL_TASK_ID = 'cai_attachments_backfill_task';
const getCAIAttachmentsBackfillTaskId = (spaceId, owner) => {
  return `${CAI_ATTACHMENTS_BACKFILL_TASK_ID}-${owner}-${spaceId}`;
};
exports.getCAIAttachmentsBackfillTaskId = getCAIAttachmentsBackfillTaskId;
const getAttachmentsSynchronizationSourceQuery = (lastSyncAt, spaceId, owner) => {
  const baseQuery = getAttachmentsSourceQuery(spaceId, owner);
  return {
    bool: {
      filter: baseQuery.bool.filter,
      must: [...baseQuery.bool.must, {
        bool: {
          should: [{
            range: {
              'cases-comments.created_at': {
                gte: lastSyncAt.toISOString()
              }
            }
          }, {
            range: {
              'cases-comments.updated_at': {
                gte: lastSyncAt.toISOString()
              }
            }
          }]
        }
      }]
    }
  };
};
exports.getAttachmentsSynchronizationSourceQuery = getAttachmentsSynchronizationSourceQuery;