"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopsPalettePicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _i18n = require("@kbn/i18n");
var _palette_picker = require("../palette_picker");
var _stop_color_picker = require("./stop_color_picker");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/palette_picker/stops_palette_picker/stops_palette_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAddColorStopLabel: () => _i18n.i18n.translate('xpack.canvas.stopsPalettePicker.addColorStopLabel', {
    defaultMessage: 'Add color stop'
  }),
  getColorStopsLabel: () => _i18n.i18n.translate('xpack.canvas.stopsPalettePicker.colorStopsLabel', {
    defaultMessage: 'Color stops'
  })
};
const defaultStops = [0, 1];
const MIN_STOPS = 2;
const StopsPalettePicker = props => {
  var _props$palette;
  const {
    palette,
    onChange
  } = props;
  const stops = (0, _react.useMemo)(() => !(palette !== null && palette !== void 0 && palette.stops) || !palette.stops.length ? defaultStops : palette.stops, [palette === null || palette === void 0 ? void 0 : palette.stops]);
  const colors = (0, _react.useMemo)(() => (0, _utils.reduceColorsByStopsSize)(palette === null || palette === void 0 ? void 0 : palette.colors, stops.length), [palette === null || palette === void 0 ? void 0 : palette.colors, stops.length]);
  const onChangePalette = (0, _react.useCallback)(newPalette => {
    if (newPalette) {
      var _props$onChange;
      const newColors = (0, _utils.reduceColorsByStopsSize)(newPalette === null || newPalette === void 0 ? void 0 : newPalette.colors, stops.length);
      (_props$onChange = props.onChange) === null || _props$onChange === void 0 ? void 0 : _props$onChange.call(props, {
        ...palette,
        ...newPalette,
        colors: newColors,
        stops
      });
    }
  }, [palette, props, stops]);
  (0, _useEffectOnce.default)(() => {
    onChangePalette({
      ...(0, _utils.getOverridenPaletteOptions)(),
      ...palette
    });
  });
  const paletteColorStops = (0, _react.useMemo)(() => (0, _utils.transformPaletteToColorStops)({
    stops,
    colors
  }), [colors, stops]);
  const updatePalette = (0, _react.useCallback)(fn => (0, _lodash.flowRight)(onChange !== null && onChange !== void 0 ? onChange : _lodash.identity, (0, _utils.mergeColorStopsWithPalette)(palette), fn), [onChange, palette]);
  const deleteColorStopAndApply = (0, _react.useCallback)(index => updatePalette((0, _utils.deleteColorStop)(index))(paletteColorStops), [paletteColorStops, updatePalette]);
  const updateColorStopAndApply = (0, _react.useCallback)((index, colorStop) => updatePalette((0, _utils.updateColorStop)(index, colorStop))(paletteColorStops), [paletteColorStops, updatePalette]);
  const addColorStopAndApply = (0, _react.useCallback)(() => updatePalette((0, _utils.addNewColorStop)(palette))(paletteColorStops), [palette, paletteColorStops, updatePalette]);
  const stopColorPickers = paletteColorStops.map(({
    id,
    ...rest
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_stop_color_picker.StopColorPicker, (0, _extends2.default)({}, rest, {
    key: index,
    removable: index >= MIN_STOPS,
    onDelete: () => deleteColorStopAndApply(index),
    onChange: cp => updateColorStopAndApply(index, cp),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_palette_picker.PalettePicker, {
    additionalPalettes: (palette === null || palette === void 0 ? void 0 : palette.id) === 'custom' ? [palette] : [],
    palette: (_props$palette = props.palette) !== null && _props$palette !== void 0 ? _props$palette : undefined,
    onChange: onChangePalette,
    clearable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getColorStopsLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, stopColorPickers))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    color: "primary",
    "aria-label": strings.getAddColorStopLabel(),
    size: "xs",
    flush: "left",
    onClick: addColorStopAndApply,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, strings.getAddColorStopLabel()));
};
exports.StopsPalettePicker = StopsPalettePicker;