"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldsSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/es_fields_select/es_fields_select.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ESFieldsSelect = ({
  selected = [],
  fields = [],
  onChange,
  onFocus,
  onBlur
}) => {
  const options = fields.map(value => ({
    label: value
  }));
  const selectedOptions = selected.map(value => ({
    label: value
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: selectedOptions,
    options: options,
    onChange: values => onChange(values.map(({
      label
    }) => label)),
    className: "canvasFieldsSelect",
    onFocus: onFocus,
    onBlur: onBlur,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.canvas.esFieldsSelect.comboBoxAriaLabel', {
      defaultMessage: 'Elasticsearch fields'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};
exports.ESFieldsSelect = ESFieldsSelect;