"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlParamsProvider = exports.UrlParamsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _helpers = require("./helpers");
var _resolve_url_params = require("./resolve_url_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/url_params_context/url_params_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultRefresh = _time => {};
const UrlParamsContext = exports.UrlParamsContext = /*#__PURE__*/(0, _react.createContext)({
  rangeId: 0,
  refreshTimeRange: defaultRefresh,
  urlParams: {}
});
const UrlParamsProvider = exports.UrlParamsProvider = (0, _reactRouterDom.withRouter)(({
  location,
  children
}) => {
  const refUrlParams = (0, _react.useRef)((0, _resolve_url_params.resolveUrlParams)(location, {}));
  const {
    start,
    end,
    rangeFrom,
    rangeTo
  } = refUrlParams.current;

  // Counter to force an update in useFetcher when the refresh button is clicked.
  const [rangeId, setRangeId] = (0, _react.useState)(0);
  const urlParams = (0, _react.useMemo)(() => (0, _resolve_url_params.resolveUrlParams)(location, {
    start,
    end,
    rangeFrom,
    rangeTo
  }), [location, start, end, rangeFrom, rangeTo]);
  refUrlParams.current = urlParams;
  const refreshTimeRange = (0, _react.useCallback)(timeRange => {
    refUrlParams.current = {
      ...refUrlParams.current,
      ...(0, _helpers.getDateRange)({
        state: {},
        ...timeRange
      })
    };
    setRangeId(prevRangeId => prevRangeId + 1);
  }, []);
  const contextValue = (0, _react.useMemo)(() => {
    return {
      rangeId,
      refreshTimeRange,
      urlParams
    };
  }, [rangeId, refreshTimeRange, urlParams]);
  return /*#__PURE__*/_react.default.createElement(UrlParamsContext.Provider, {
    children: children,
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
});